/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.AbstractRegistry;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DefaultImagePushProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePush;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class PushImageCommandHandler
extends AbstractHandler {
    private static final String PUSH_IMAGE_JOB_TITLE = "ImagePush.title";
    private static final String PUSH_IMAGE_JOB_TASK = "ImagePush.msg";
    private static final String ERROR_PUSHING_IMAGE = "ImagePushError.msg";
    private static final String NO_CONNECTION = "NoConnection.error";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerImage selectedImage = CommandUtils.getSelectedImage(activePart);
        ImagePush wizard = new ImagePush(selectedImage, String.valueOf(selectedImage.repo()) + ":" + (String)selectedImage.tags().get(0));
        boolean pushImage = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (pushImage) {
            IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
            this.performPushImage(wizard, connection);
        }
        return null;
    }

    private void performPushImage(final ImagePush wizard, final IDockerConnection connection) {
        if (connection == null) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(ERROR_PUSHING_IMAGE, wizard.getSelectedImageTag()), (String)DVMessages.getFormattedString(NO_CONNECTION, new String[0])));
            return;
        }
        Job pushImageJob = new Job(DVMessages.getFormattedString(PUSH_IMAGE_JOB_TITLE, wizard.getSelectedImageTag())){

            protected IStatus run(IProgressMonitor monitor) {
                block20: {
                    IDockerImage image = wizard.getImage();
                    String defaultImageNameTag = wizard.getDefaultImageName();
                    String selectedImageNameTag = wizard.getSelectedImageTag();
                    AbstractRegistry registry = (AbstractRegistry)wizard.getRegistry();
                    boolean forceTagging = wizard.isForceTagging();
                    boolean keepTaggedImage = wizard.isKeepTaggedImage();
                    monitor.beginTask(DVMessages.getString(PushImageCommandHandler.PUSH_IMAGE_JOB_TASK), -1);
                    String tmpRegistryTag = PushImageCommandHandler.getNameToTag(selectedImageNameTag, registry);
                    boolean tagCreated = false;
                    try {
                        try {
                            if (!image.repoTags().contains(tmpRegistryTag) || forceTagging) {
                                ((DockerConnection)connection).tagImage(defaultImageNameTag, tmpRegistryTag, forceTagging);
                                tagCreated = true;
                            }
                            if (!registry.isAuthProvided()) {
                                connection.pushImage(tmpRegistryTag, (IDockerProgressHandler)new DefaultImagePushProgressHandler(connection, tmpRegistryTag));
                                break block20;
                            }
                            IRegistryAccount registryAccount = (IRegistryAccount)registry;
                            connection.pushImage(tmpRegistryTag, registryAccount, (IDockerProgressHandler)new DefaultImagePushProgressHandler(connection, tmpRegistryTag));
                        }
                        catch (DockerException e) {
                            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(PushImageCommandHandler.ERROR_PUSHING_IMAGE, defaultImageNameTag), (String)e.getMessage()));
                            Activator.logErrorMessage(DVMessages.getFormattedString(PushImageCommandHandler.ERROR_PUSHING_IMAGE, defaultImageNameTag), e);
                            if (tagCreated && !keepTaggedImage) {
                                try {
                                    connection.removeTag(tmpRegistryTag);
                                    connection.getImages(true);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            monitor.done();
                        }
                        catch (InterruptedException interruptedException) {
                            if (tagCreated && !keepTaggedImage) {
                                try {
                                    connection.removeTag(tmpRegistryTag);
                                    connection.getImages(true);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            monitor.done();
                        }
                    }
                    finally {
                        if (tagCreated && !keepTaggedImage) {
                            try {
                                connection.removeTag(tmpRegistryTag);
                                connection.getImages(true);
                            }
                            catch (Exception exception) {}
                        }
                        monitor.done();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        pushImageJob.schedule();
    }

    private static String getNameToTag(String repoTag, AbstractRegistry registry) {
        if (registry.isDockerHubRegistry()) {
            return repoTag;
        }
        return String.valueOf(registry.getServerHost()) + '/' + repoTag;
    }
}

