/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.model.plugin.internal;

import java.io.Serializable;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.eclipse.jwt.we.conf.model.PluginProperties;
import org.eclipse.jwt.we.conf.model.plugin.internal.Level;

public class Logger
extends java.util.logging.Logger
implements Serializable {
    private static final long serialVersionUID = 7716168226984601813L;
    private java.util.logging.Logger internalLogger = null;

    public Logger(java.util.logging.Logger logger) {
        super(logger.getName(), logger.getResourceBundleName());
        this.internalLogger = logger;
        this.setLevel(this.getLoggingLevel());
        this.internalLogger.setLevel(this.getLoggingLevel());
    }

    public Logger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.setLevel(this.getLoggingLevel());
    }

    private java.util.logging.Level getLoggingLevel() {
        if (PluginProperties.logging_level.equals(Level.DEBUG.getName())) {
            return Level.DEBUG;
        }
        if (PluginProperties.logging_level.equals(Level.DEBUG_WARNING.getName())) {
            return Level.DEBUG_WARNING;
        }
        if (PluginProperties.logging_level.equals(Level.ENTER.getName())) {
            return Level.ENTER;
        }
        if (PluginProperties.logging_level.equals(Level.EXIT.getName())) {
            return Level.EXIT;
        }
        if (PluginProperties.logging_level.equals(Level.INSTANCE_CREATION.getName())) {
            return Level.INSTANCE_CREATION;
        }
        if (PluginProperties.logging_level.equals(Level.THROWING.getName())) {
            return Level.THROWING;
        }
        if (PluginProperties.logging_level.equals(Level.VALUE_CHANGED.getName())) {
            return Level.VALUE_CHANGED;
        }
        if (PluginProperties.logging_level.equals(Level.ALL.getName())) {
            return Level.ALL;
        }
        if (PluginProperties.logging_level.equals(Level.CONFIG.getName())) {
            return Level.CONFIG;
        }
        if (PluginProperties.logging_level.equals(Level.FINE.getName())) {
            return Level.FINE;
        }
        if (PluginProperties.logging_level.equals(Level.FINER.getName())) {
            return Level.FINER;
        }
        if (PluginProperties.logging_level.equals(Level.FINEST.getName())) {
            return Level.FINEST;
        }
        if (PluginProperties.logging_level.equals(Level.INFO.getName())) {
            return Level.INFO;
        }
        if (PluginProperties.logging_level.equals(Level.OFF.getName())) {
            return Level.OFF;
        }
        if (PluginProperties.logging_level.equals(Level.SEVERE.getName())) {
            return Level.SEVERE;
        }
        if (PluginProperties.logging_level.equals(Level.WARNING.getName())) {
            return Level.WARNING;
        }
        return null;
    }

    public static synchronized Logger getLogger(Class clazz) {
        String name = clazz.getName();
        LogManager manager = LogManager.getLogManager();
        java.util.logging.Logger logger = manager.getLogger(name);
        if (logger == null) {
            logger = new Logger(name, null);
            manager.addLogger(logger);
            logger = manager.getLogger(name);
        }
        Logger result = logger instanceof Logger ? (Logger)logger : new Logger(logger);
        return result;
    }

    public void log(LogRecord record) {
        String cname;
        StackTraceElement frame;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int ix = 0;
        String thisClass = this.getClass().getName();
        String utilLoggerClass = java.util.logging.Logger.class.getName();
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (cname.equals(thisClass)) break;
            ++ix;
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(thisClass) && !cname.equals(utilLoggerClass)) {
                record.setSourceClassName(cname);
                record.setSourceMethodName(frame.getMethodName());
                break;
            }
            ++ix;
        }
        if (this.internalLogger == null) {
            super.log(record);
        } else {
            this.internalLogger.log(record);
        }
    }

    public boolean isDebugEnabled() {
        return this.isLoggable(Level.DEBUG);
    }

    public void valueChanged(String name) {
        this.log((java.util.logging.Level)Level.VALUE_CHANGED, name);
    }

    public void valueChanged(String name, Object newValue) {
        this.log((java.util.logging.Level)Level.VALUE_CHANGED, String.valueOf(name) + " = \"{0}\"", newValue);
    }

    public void valueChanged(String name, Object oldValue, Object newValue) {
        this.log((java.util.logging.Level)Level.VALUE_CHANGED, String.valueOf(name) + ": \"{0}\" -> \"{1}\"", new Object[]{oldValue, newValue});
    }

    public void instanceCreation() {
    }

    public void instanceCreation(String name) {
        this.log((java.util.logging.Level)Level.INSTANCE_CREATION, name);
    }

    public void enter() {
    }

    public void enter(String message) {
        this.log((java.util.logging.Level)Level.ENTER, message);
    }

    public void exit() {
    }

    public void exit(Object result) {
        this.log((java.util.logging.Level)Level.EXIT, null, result);
    }

    public void exit(String message) {
        this.log((java.util.logging.Level)Level.EXIT, message);
    }

    public void debug(String message) {
        this.log((java.util.logging.Level)Level.DEBUG, message);
    }

    public void debug(Throwable exception) {
        this.log((java.util.logging.Level)Level.DEBUG, null, exception);
    }

    public void debugWarning(String msg) {
        this.log((java.util.logging.Level)Level.DEBUG_WARNING, msg);
    }

    public void debugWarning(String msg, Throwable exception) {
        this.log((java.util.logging.Level)Level.DEBUG_WARNING, msg, exception);
    }

    public void warning(Throwable exception) {
        this.log(java.util.logging.Level.WARNING, null, exception);
    }

    public void warning(String msg, Throwable exception) {
        this.log(java.util.logging.Level.WARNING, msg, exception);
    }

    public void warning(String msg, Object param, Throwable exception) {
        LogRecord record = new LogRecord(java.util.logging.Level.WARNING, msg);
        record.setParameters(new Object[]{param});
        record.setThrown(exception);
        this.log(record);
    }

    public void severe(String msg, Throwable exception) {
        this.log(java.util.logging.Level.SEVERE, msg, exception);
    }
}

