/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringParsing {
    public static final int DEFAULTMASK = 0;
    public static final int LISTCOMBOMASK = 1;
    public static final int MENUTREEMASK = 2;
    public static final String SINGLEQUOTE = "'";
    public static final String MASKED_SINGLEQUOTE = "'\\\\''";
    public static final String ALHANUMERIC = "[A-Za-z0-9]*";

    private StringParsing() {
    }

    public static List<String> splitToList(String string, char delimeter, char escape, boolean includeEmptyToken) {
        ArrayList<String> list = new ArrayList<String>();
        if (string == null) {
            return list;
        }
        int length = string.length();
        if (length == 0) {
            list.add(new String());
            return list;
        }
        int index = 0;
        int postIndex = 0;
        boolean escapeNextChar = false;
        boolean delimWasLastChar = false;
        StringBuffer word = new StringBuffer();
        while (index < length) {
            int n = postIndex = index < string.length() - 1 ? index + 1 : index;
            if (string.charAt(index) == escape && string.charAt(postIndex) == delimeter && !escapeNextChar) {
                delimWasLastChar = false;
                escapeNextChar = true;
            } else if (string.charAt(index) == delimeter && !escapeNextChar) {
                if (word.length() > 0 || includeEmptyToken) {
                    list.add(word.toString());
                    word.delete(0, word.length());
                }
                delimWasLastChar = true;
                escapeNextChar = false;
            } else {
                word.append(string.charAt(index));
                delimWasLastChar = false;
                escapeNextChar = false;
            }
            ++index;
        }
        if (word.length() > 0 || includeEmptyToken && delimWasLastChar) {
            list.add(word.toString());
        }
        return list;
    }

    public static String[] splitToArray(String string, char delimeter, char escape) {
        return StringParsing.splitToArray(string, delimeter, escape, false);
    }

    public static String[] splitToArray(String string, char delimeter, char escape, boolean includeEmptyToken) {
        List<String> list = StringParsing.splitToList(string, delimeter, escape, includeEmptyToken);
        return list.toArray(new String[list.size()]);
    }

    public static int countWords(String text) {
        if (text != null) {
            int count = text.split("\\s+").length;
            return count;
        }
        return 0;
    }

    public static String singleQuoteText(String string) {
        if (string == null || string.equals("")) {
            return "''";
        }
        if (!string.matches(ALHANUMERIC)) {
            String str = string.replaceAll(SINGLEQUOTE, MASKED_SINGLEQUOTE);
            return SINGLEQUOTE + str + SINGLEQUOTE;
        }
        return string;
    }

    public static String maskAndSingleQuoteText(String string, int mask) {
        String maskedString = StringParsing.singleQuoteText(string);
        if (mask == 1) {
            maskedString = maskedString.replaceAll(",", "\\\\,");
        }
        if (mask == 2) {
            maskedString = maskedString.replaceAll("/", "\\\\/");
        }
        return maskedString;
    }

    public static String boolToString(boolean b) {
        String str = b ? "true" : "false";
        return str;
    }

    public static String incrementSequence(String str) {
        return StringParsing.incrementSequence(str, "_");
    }

    public static String incrementSequence(String str, String sequencePrefix) {
        Validate.notEmpty((String)str);
        Validate.notEmpty((String)sequencePrefix);
        StringBuffer builder = new StringBuffer(str);
        String suffix = StringUtils.substringAfterLast((String)str, (String)"_");
        int sequence = -1;
        try {
            sequence = Integer.parseInt(suffix);
            if (sequence > 0) {
                ++sequence;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (sequence > 0) {
            builder.replace(builder.lastIndexOf(suffix), builder.length(), String.valueOf(sequence));
        } else {
            builder.append(sequencePrefix).append(1);
        }
        return builder.toString();
    }

    public static Map<String, String> convertToMap(String map) {
        String[] pairs;
        HashMap<String, String> propMap = new HashMap<String, String>();
        int indexOfCurl = map.indexOf("{");
        int lastIndexOfCurl = map.lastIndexOf("}");
        if (map.length() < 2 || indexOfCurl == -1 || lastIndexOfCurl == -1) {
            return propMap;
        }
        String props = map.substring(indexOfCurl + 1, lastIndexOfCurl);
        String[] stringArray = pairs = props.split(",");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] kv = pair.split("=");
            if (kv.length == 2) {
                propMap.put(kv[0].trim(), kv[1].trim());
            } else {
                propMap.put(kv[0].trim(), "");
            }
            ++n2;
        }
        return propMap;
    }
}

