/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.utils;

import java.io.IOException;
import java.net.ServerSocket;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetUtil.class);

    private NetUtil() {
    }

    public static int getFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            LOG.error("Error occurred while searching for available port. Invalid port will be returned.", (Throwable)e);
            return -1;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOG.error("Error occurred while searching for available port.", (Throwable)e);
                }
            }
        }
    }

    public static String isPortNumberValid(String value) {
        try {
            int portValue = Integer.parseInt(value);
            if (portValue < 1024 || portValue > 65536) {
                return I18n.getString("ErrorMessage.INVALID_PORT_NUMBER");
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return I18n.getString("ErrorMessage.INVALID_PORT_NUMBER");
        }
    }
}

