/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.listener;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.listener.BaseAUTListener;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableSelectionTracker
implements BaseAUTListener,
Listener {
    private static TableSelectionTracker instance;
    private Map m_tableToSelection = new HashMap();
    private Map m_tableToCursorSelection = new HashMap();
    private Map m_cursorToTable = new HashMap();

    private TableSelectionTracker() {
    }

    public static TableSelectionTracker getInstance() {
        if (instance == null) {
            instance = new TableSelectionTracker();
        }
        return instance;
    }

    public Cell getSelectedCell(Table table) throws StepExecutionException {
        Display d;
        Control focusControl;
        Cell selectedCell = (Cell)this.m_tableToCursorSelection.get(table);
        if (selectedCell == null && (focusControl = (d = table.getDisplay()).getFocusControl()) != null) {
            Rectangle bounds = d.map((Control)focusControl.getParent(), null, focusControl.getBounds());
            Point center = new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
            if (d.map((Control)table.getParent(), null, table.getBounds()).contains(center)) {
                int row = 0;
                while (row < table.getItemCount() && selectedCell == null) {
                    int col = 0;
                    while (col < table.getColumnCount() && selectedCell == null) {
                        if (d.map((Control)table, null, table.getItem(row).getBounds(col)).contains(center)) {
                            selectedCell = new Cell(row, col);
                        }
                        ++col;
                    }
                    ++row;
                }
            }
        }
        if (selectedCell == null) {
            selectedCell = (Cell)this.m_tableToSelection.get(table);
        }
        if (selectedCell == null) {
            throw new StepExecutionException("No table cell selected.", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        return selectedCell;
    }

    public long[] getEventMask() {
        return new long[]{13L, 12L, 10L};
    }

    public void handleEvent(Event event) {
        if ((event.type == 13 || event.type == 14) && event.widget instanceof Table) {
            this.handleTableSelection((Table)event.widget);
        } else if (event.type == 12) {
            this.handleDisposeEvent(event);
        } else if (event.type == 10 && event.widget instanceof TableCursor) {
            this.handleTableCursorMoved((TableCursor)event.widget);
        }
    }

    private void handleTableCursorMoved(TableCursor tableCursor) {
        TableItem selectedRow = tableCursor.getRow();
        if (selectedRow != null) {
            Table table = selectedRow.getParent();
            int selectedRowIdx = table.indexOf(selectedRow);
            int selectedColIdx = tableCursor.getColumn();
            this.m_tableToCursorSelection.put(table, new Cell(selectedRowIdx, selectedColIdx));
            this.m_cursorToTable.put(tableCursor, table);
        } else {
            this.m_tableToCursorSelection.remove(this.m_cursorToTable.get(tableCursor));
            this.m_cursorToTable.remove(tableCursor);
        }
    }

    private void handleDisposeEvent(Event event) {
        if (event.widget instanceof Table) {
            this.m_tableToSelection.remove(event.widget);
            this.m_tableToCursorSelection.remove(event.widget);
        } else if (event.widget instanceof TableCursor) {
            TableCursor eventCursor = (TableCursor)event.widget;
            this.m_tableToCursorSelection.remove(this.m_cursorToTable.get(eventCursor));
            this.m_cursorToTable.remove(eventCursor);
        }
    }

    private void handleTableSelection(Table table) {
        int selectionIndex = table.getSelectionIndex();
        if (selectionIndex != -1) {
            this.m_tableToSelection.put(table, new Cell(selectionIndex, 0));
        } else {
            this.m_tableToSelection.remove(table);
        }
    }
}

