/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.driver;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RunnableWrapper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventThreadQueuerSwtImpl
implements IEventThreadQueuer {
    private static AutServerLogger log = new AutServerLogger(EventThreadQueuerSwtImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <V> V invokeAndWait(String name, IRunnable<V> runnable) throws IllegalArgumentException, StepExecutionException {
        Validate.notNull(runnable, (String)"runnable must not be null");
        RunnableWrapper wrapper = new RunnableWrapper(name, runnable);
        try {
            Display display = this.getDisplay();
            if (display.isDisposed()) {
                log.warn((Object)"Display has already been disposed - skipping IRunnable invocation!");
                return null;
            }
            try {
                display.syncExec((Runnable)wrapper);
            }
            catch (SWTException e) {
                if (display.isDisposed()) {
                    log.warn((Object)"Display has disposed while waiting for IRunnable execution!");
                    return null;
                }
                log.warn((Object)"SWTException while waiting for IRunnable execution!", (Throwable)e);
            }
            StepExecutionException exception = wrapper.getException();
            if (exception == null) return (V)wrapper.getResult();
            throw new InvocationTargetException((Throwable)exception);
        }
        catch (InvocationTargetException ite) {
            Throwable thrown = ite.getTargetException();
            if (thrown instanceof StepExecutionException) {
                if (!log.isInfoEnabled()) throw (StepExecutionException)thrown;
                log.info((Object)ite);
                throw (StepExecutionException)thrown;
            }
            log.error((Object)("exception thrown by '" + wrapper.getName() + "':"), thrown);
            throw new StepExecutionException(thrown);
        }
    }

    public void invokeLater(String name, Runnable runnable) throws StepExecutionException {
        Validate.notNull((Object)runnable, (String)"runnable must not be null");
        this.getDisplay().asyncExec(runnable);
    }

    private Display getDisplay() {
        return ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
    }

    public <V> V invokeAndWait(String name, Callable<V> callable, long timeout) throws StepExecutionException, TimeoutException {
        Display display = this.getDisplay();
        if (display.isDisposed()) {
            log.warn((Object)"Display has already been disposed - skipping IRunnable invocation!");
            return null;
        }
        try {
            FutureTask<V> task = new FutureTask<V>(callable);
            this.getDisplay().asyncExec(task);
            return task.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (SWTException e) {
            if (display.isDisposed()) {
                log.warn((Object)"Display has disposed while waiting for IRunnable execution!");
                return null;
            }
            log.warn((Object)"SWTException while waiting for IRunnable execution!", (Throwable)e);
        }
        catch (InterruptedException ie) {
            log.error((Object)ie);
            throw new StepExecutionException((Throwable)ie);
        }
        catch (ExecutionException ee) {
            Throwable thrown = ee.getCause();
            if (thrown instanceof StepExecutionException) {
                if (log.isInfoEnabled()) {
                    log.info((Object)ee);
                }
                throw (StepExecutionException)thrown;
            }
            log.error((Object)("exception thrown by '" + name + "':"), thrown);
            throw new StepExecutionException(thrown);
        }
        return null;
    }
}

