/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.search.SearchResultPage;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.jubula.client.ui.rcp.utils.SearchPageUtils;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.SearchReplaceTCRWizard;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Shell;

public class SearchReplaceTestCaseHandler
extends AbstractSelectionBasedHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object executeImpl(ExecutionEvent event) {
        if (!Plugin.getDefault().showSaveEditorDialog(this.getActiveShell())) {
            return null;
        }
        IStructuredSelection selectedObject = this.getSelection();
        List selectionList = selectedObject.toList();
        LinkedHashSet<IExecTestCasePO> execList = new LinkedHashSet<IExecTestCasePO>();
        EntityManager session = GeneralStorage.getInstance().getMasterSession();
        ISpecTestCasePO firstSpec = null;
        IProjectPO project = GeneralStorage.getInstance().getProject();
        boolean error = false;
        try {
            for (Object object : selectionList) {
                BasicSearchResult.SearchResultElement searchResult = (BasicSearchResult.SearchResultElement)object;
                INodePO nodePO = (INodePO)session.find(NodeMaker.getNodePOClass(), searchResult.getData());
                if (nodePO instanceof IExecTestCasePO) {
                    IExecTestCasePO exec = (IExecTestCasePO)nodePO;
                    if (exec.getParentProjectId().equals(project.getId())) {
                        execList.add(exec);
                    } else {
                        error = true;
                    }
                    ISpecTestCasePO spec = exec.getSpecTestCase();
                    if (firstSpec == null) {
                        firstSpec = spec;
                    }
                    if (firstSpec.equals((Object)spec)) continue;
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_NOT_SAME_SPEC);
                    return null;
                }
                error = true;
            }
        }
        catch (Exception exception) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_NO_EXEC);
            return null;
        }
        if (!error) {
            this.showWizardDialog(execList);
            return null;
        }
        if (MessageDialog.openQuestion(null, (String)Messages.ReplaceMultiTCRWizardActionDialog, (String)Messages.ReplaceMultiTCRWizardQuestionDeselect)) {
            SearchResultPage page = SearchPageUtils.getSearchResultPage(event);
            LinkedList<ITestCasePO> bla = new LinkedList<ITestCasePO>();
            bla.addAll(execList);
            SearchPageUtils.selectTestCases(page, selectionList, bla);
        }
        return null;
    }

    private void showWizardDialog(Set<IExecTestCasePO> execList) {
        WizardDialog dialog = new WizardDialog(this.getActiveShell(), (IWizard)new SearchReplaceTCRWizard(execList)){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
            }
        };
        dialog.setMinimumPageSize(775, 300);
        dialog.setPageSize(775, 300);
        dialog.setHelpAvailable(true);
        dialog.open();
    }
}

