/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.utils.AbstractParamValueToken;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public class SimpleValueToken
extends AbstractParamValueToken {
    public SimpleValueToken(String s, int pos, IParamDescriptionPO desc) {
        super(s, pos, desc);
    }

    @Override
    public ParamValueConverter.ConvValidationState validate() {
        ParamValueConverter.ConvValidationState state = ParamValueConverter.ConvValidationState.notSet;
        if ("guidancer.datatype.Variable".equals(this.getParamDescription().getType())) {
            if (Pattern.matches("[0-9a-z_A-Z]{1,}", this.getValue())) {
                state = ParamValueConverter.ConvValidationState.valid;
            } else {
                state = ParamValueConverter.ConvValidationState.invalid;
                this.setErrorKey(MessageIDs.E_PARSE_NAME_ERROR);
            }
        }
        return state;
    }

    @Override
    public String getGuiString() {
        return this.getValue();
    }

    @Override
    public String getExecutionString(List<ExecObject> stack) throws InvalidDataException {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        do {
            char c;
            if ((c = this.getValue().charAt(index)) == '\\') {
                if (index + 1 < this.getValue().length()) {
                    c = this.getValue().charAt(++index);
                    char[] validChars = new char[]{'\\', '=', '{', '}', '$', '\''};
                    boolean isValid = false;
                    char[] cArray = validChars;
                    int n = validChars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char validChar = cArray[n2];
                        if (validChar == c) {
                            builder.append(c);
                            isValid = true;
                            ++index;
                            break;
                        }
                        ++n2;
                    }
                    if (isValid) continue;
                    StringBuilder msg = new StringBuilder();
                    msg.append(Messages.InvalidCharacter);
                    msg.append(" ");
                    msg.append(c);
                    msg.append(" ");
                    msg.append(Messages.AfterBackslashIn);
                    msg.append(" ");
                    msg.append(this.getValue());
                    throw new InvalidDataException(msg.toString(), MessageIDs.E_SYNTAX_ERROR);
                }
                throw new InvalidDataException(String.valueOf(Messages.NotAllowedToSetSingleBackslashIn) + " " + this.getValue(), MessageIDs.E_SYNTAX_ERROR);
            }
            builder.append(c);
            ++index;
        } while (index < this.getValue().length());
        return builder.toString();
    }

    @Override
    public String getModelString() {
        return this.getValue();
    }
}

