/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.treeoperations.FindNodesForComponentNameOp;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentNamesBP {
    public static final String UNKNOWN_COMPONENT_TYPE = "guidancer.abstract.Unknown";
    private static Logger log = LoggerFactory.getLogger(ComponentNamesBP.class);

    private ComponentNamesBP() {
    }

    public static void setCompName(ICapPO capPo, String compName, CompNameCreationContext ctx, IWritableComponentNameCache compCache) {
        String oldGuid = capPo.getComponentName();
        if (StringUtils.isBlank((String)compName)) {
            compCache.changeReuse(capPo, oldGuid, null);
            return;
        }
        String guidToSet = compCache.getGuidForName(compName, GeneralStorage.getInstance().getProject().getId());
        if (guidToSet == null) {
            IComponentNamePO newComponentNamePO = compCache.createComponentNamePO(compName, capPo.getComponentType(), ctx);
            if (capPo.getParentProjectId() != null) {
                newComponentNamePO.setParentProjectId(capPo.getParentProjectId());
            }
            guidToSet = newComponentNamePO.getGuid();
        }
        compCache.changeReuse(capPo, oldGuid, guidToSet);
    }

    public static Set<INodePO> findNodesOfReuse(Collection<ISpecPersistable> specsToSearch, Collection<ITestSuitePO> suitesToSearch, String compNameGuid, IProgressMonitor monitor) {
        TreeTraverser traverser;
        FindNodesForComponentNameOp op;
        HashSet<INodePO> reuse = new HashSet<INodePO>();
        monitor.beginTask(Messages.ShowWhereUsedSearching, specsToSearch.size() + suitesToSearch.size());
        for (ISpecPersistable node : specsToSearch) {
            op = new FindNodesForComponentNameOp(compNameGuid);
            traverser = new TreeTraverser(node, op);
            traverser.traverse(true);
            reuse.addAll(op.getNodes());
            monitor.worked(1);
        }
        for (ITestSuitePO ts : suitesToSearch) {
            op = new FindNodesForComponentNameOp(compNameGuid);
            traverser = new TreeTraverser(ts, op);
            traverser.traverse(true);
            reuse.addAll(op.getNodes());
            monitor.worked(1);
        }
        return reuse;
    }

    public static Set<IObjectMappingAssoziationPO> findAssocsOfReuse(Collection<IAUTMainPO> autsToSearch, String compNameGuid) {
        HashSet<IObjectMappingAssoziationPO> reuse = new HashSet<IObjectMappingAssoziationPO>();
        for (IAUTMainPO aut : autsToSearch) {
            for (IObjectMappingAssoziationPO assoc : aut.getObjMap().getMappings()) {
                if (assoc.getTechnicalName() == null || !assoc.getLogicalNames().contains(compNameGuid)) continue;
                reuse.add(assoc);
            }
        }
        return reuse;
    }

    public static enum CompNameCreationContext {
        CN_BROWSER,
        OBJECT_MAPPING,
        OVERRIDDEN_NAME,
        STEP;

        private static final String CN_BROWSER_CTX = "CN_BROWSER";
        private static final String OBJECT_MAPPING_CTX = "OBJECT_MAPPING";
        private static final String OVERRIDDEN_NAME_CTX = "OVERRIDDEN_NAME";
        private static final String STEP_CTX = "STEP";

        public String toString() {
            switch (this) {
                case CN_BROWSER: {
                    return CN_BROWSER_CTX;
                }
                case OBJECT_MAPPING: {
                    return OBJECT_MAPPING_CTX;
                }
                case OVERRIDDEN_NAME: {
                    return OVERRIDDEN_NAME_CTX;
                }
                case STEP: {
                    return STEP_CTX;
                }
            }
            Assert.notReached((String)"Missing toString representation for CompNameCreationContext");
            return "";
        }

        public static CompNameCreationContext forName(String name) {
            if (CN_BROWSER_CTX.equals(name)) {
                return CN_BROWSER;
            }
            if (OBJECT_MAPPING_CTX.equalsIgnoreCase(name)) {
                return OBJECT_MAPPING;
            }
            if (OVERRIDDEN_NAME_CTX.equalsIgnoreCase(name)) {
                return OVERRIDDEN_NAME;
            }
            if (STEP_CTX.equalsIgnoreCase(name)) {
                return STEP;
            }
            Assert.notReached((String)("No CompNameCreationContext for '" + String.valueOf(name) + "'"));
            return null;
        }
    }
}

