/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.LongObjectId;

public class LfsPointer {
    public static final String VERSION = "https://git-lfs.github.com/spec/v1";
    public static final String VERSION_LEGACY = "https://hawser.github.com/spec/v1";
    public static final String HASH_FUNCTION_NAME = "SHA-256".toLowerCase(Locale.ROOT).replace("-", "");
    private AnyLongObjectId oid;
    private long size;

    public LfsPointer(AnyLongObjectId oid, long size) {
        this.oid = oid;
        this.size = size;
    }

    public AnyLongObjectId getOid() {
        return this.oid;
    }

    public long getSize() {
        return this.size;
    }

    public void encode(OutputStream out) {
        try (PrintStream ps = new PrintStream(out, false, StandardCharsets.UTF_8.name());){
            ps.print("version ");
            ps.print("https://git-lfs.github.com/spec/v1\n");
            ps.print("oid " + HASH_FUNCTION_NAME + ":");
            ps.print(this.oid.name() + "\n");
            ps.print("size ");
            ps.print(this.size + "\n");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(StandardCharsets.UTF_8.name());
        }
    }

    @Nullable
    public static LfsPointer parseLfsPointer(InputStream in) throws IOException {
        boolean versionLine = false;
        LongObjectId id = null;
        long sz = -1L;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8.name()));){
            String s = br.readLine();
            while (s != null) {
                if (!s.startsWith("#") && s.length() != 0) {
                    if (s.startsWith("version") && s.length() > 8 && (s.substring(8).trim().equals(VERSION) || s.substring(8).trim().equals(VERSION_LEGACY))) {
                        versionLine = true;
                    } else if (s.startsWith("oid sha256:")) {
                        id = LongObjectId.fromString(s.substring(11).trim());
                    } else if (s.startsWith("size") && s.length() > 5) {
                        sz = Long.parseLong(s.substring(5).trim());
                    }
                }
                s = br.readLine();
            }
            if (versionLine && id != null && sz > -1L) {
                LfsPointer lfsPointer = new LfsPointer(id, sz);
                return lfsPointer;
            }
        }
        return null;
    }

    public String toString() {
        return "LfsPointer: oid=" + this.oid.name() + ", size=" + this.size;
    }
}

