/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.ui.MarketplaceUrlHandler;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class MarketplaceDropAdapter
implements IStartup {
    private static final int[] PREFERRED_DROP_OPERATIONS = new int[]{16, 1, 2, 4};
    private static final int DROP_OPERATIONS = 23;
    private final DropTargetAdapter dropListener = new MarketplaceDropTargetListener();
    private final WorkbenchListener workbenchListener = new WorkbenchListener();
    private Transfer[] transferAgents;

    public void earlyStartup() {
        UIJob registerJob = new UIJob(Display.getDefault(), Messages.MarketplaceDropAdapter_0){
            {
                this.setPriority(20);
                this.setSystem(true);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow[] workbenchWindows;
                IWorkbench workbench = PlatformUI.getWorkbench();
                workbench.addWindowListener((IWindowListener)MarketplaceDropAdapter.this.workbenchListener);
                IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = workbench.getWorkbenchWindows();
                int n = workbenchWindows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    MarketplaceDropAdapter.this.workbenchListener.hookWindow(window);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        registerJob.schedule();
    }

    public void installDropTarget(Shell shell) {
        this.hookUrlTransfer(shell, this.dropListener);
    }

    private DropTarget hookUrlTransfer(Shell shell, DropTargetAdapter dropListener) {
        Control[] children;
        DropTarget target = this.findDropTarget((Control)shell);
        if (target != null) {
            this.registerWithExistingTarget(target);
        } else {
            target = new DropTarget((Control)shell, 23);
            if (this.transferAgents == null) {
                this.transferAgents = new Transfer[]{URLTransfer.getInstance()};
            }
            target.setTransfer(this.transferAgents);
        }
        this.registerDropListener(target, (DropTargetListener)dropListener);
        Control[] controlArray = children = shell.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            this.hookRecursive(child, (DropTargetListener)dropListener);
            ++n2;
        }
        return target;
    }

    private void registerDropListener(DropTarget target, DropTargetListener dropListener) {
        target.removeDropListener(dropListener);
        target.addDropListener(dropListener);
    }

    private void hookRecursive(Control child, DropTargetListener dropListener) {
        DropTarget childTarget = this.findDropTarget(child);
        if (childTarget != null) {
            this.registerWithExistingTarget(childTarget);
            this.registerDropListener(childTarget, dropListener);
        }
        if (child instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)child;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                this.hookRecursive(control, dropListener);
                ++n2;
            }
        }
    }

    private void registerWithExistingTarget(DropTarget target) {
        Transfer[] transfers = target.getTransfer();
        boolean exists = false;
        if (transfers != null) {
            Transfer[] transferArray = transfers;
            int n = transfers.length;
            int n2 = 0;
            while (n2 < n) {
                Transfer transfer = transferArray[n2];
                if (transfer instanceof URLTransfer) {
                    exists = true;
                    break;
                }
                ++n2;
            }
            if (!exists) {
                Transfer[] newTransfers = new Transfer[transfers.length + 1];
                System.arraycopy(transfers, 0, newTransfers, 0, transfers.length);
                newTransfers[transfers.length] = URLTransfer.getInstance();
                target.setTransfer(newTransfers);
            }
        }
    }

    private DropTarget findDropTarget(Control control) {
        Object object = control.getData("DropTarget");
        if (object instanceof DropTarget) {
            return (DropTarget)object;
        }
        return null;
    }

    protected void proceedInstallation(String url) {
        MarketplaceUrlHandler.SolutionInstallationInfo info = MarketplaceUrlHandler.createSolutionInstallInfo(url);
        if (info != null) {
            MarketplaceUrlHandler.triggerInstall(info);
        }
    }

    protected void proceedFavorites(String url) {
        MarketplaceUrlHandler.triggerFavorites(url);
    }

    protected boolean acceptSolutionUrl(String url) {
        return MarketplaceUrlHandler.isPotentialSolution(url);
    }

    protected boolean acceptFavoritesListUrl(String url) {
        return MarketplaceUrlHandler.isPotentialFavoritesList(url);
    }

    private class MarketplaceDropTargetListener
    extends DropTargetAdapter {
        private MarketplaceDropTargetListener() {
        }

        public void dragEnter(DropTargetEvent e) {
            this.updateDragDetails(e);
        }

        public void dragOver(DropTargetEvent e) {
            this.updateDragDetails(e);
        }

        public void dragLeave(DropTargetEvent e) {
            if (e.detail == 0) {
                this.setDropOperation(e);
            }
        }

        public void dropAccept(DropTargetEvent e) {
            this.updateDragDetails(e);
        }

        public void dragOperationChanged(DropTargetEvent e) {
            this.updateDragDetails(e);
        }

        private void setDropOperation(DropTargetEvent e) {
            int allowedOperations = e.operations;
            int[] nArray = PREFERRED_DROP_OPERATIONS;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int op = nArray[n2];
                if ((allowedOperations & op) != 0) {
                    this.traceDropOperation(op);
                    e.detail = op;
                    return;
                }
                ++n2;
            }
            e.detail = allowedOperations;
        }

        private void updateDragDetails(DropTargetEvent e) {
            if (this.dropTargetIsValid(e, false)) {
                this.setDropOperation(e);
            }
        }

        private boolean dropTargetIsValid(DropTargetEvent e, boolean isDrop) {
            if (URLTransfer.getInstance().isSupportedType(e.currentDataType)) {
                if (isDrop || Util.isWindows()) {
                    if (e.data == null && !this.extractEventData(e)) {
                        this.traceMissingEventData(e);
                        return !isDrop;
                    }
                    String url = this.getUrl(e.data);
                    if (MarketplaceDropAdapter.this.acceptSolutionUrl(url)) {
                        return true;
                    }
                    if (MarketplaceDropAdapter.this.acceptFavoritesListUrl(url)) {
                        return true;
                    }
                    this.traceInvalidEventData(e);
                    return false;
                }
                return true;
            }
            this.traceUnsupportedDataType(e);
            return false;
        }

        private boolean extractEventData(DropTargetEvent e) {
            Object data;
            TransferData transferData = e.currentDataType;
            if (transferData != null && (data = URLTransfer.getInstance().nativeToJava(transferData)) != null && this.getUrl(data) != null) {
                e.data = data;
                return true;
            }
            return false;
        }

        public void drop(DropTargetEvent event) {
            if (!URLTransfer.getInstance().isSupportedType(event.currentDataType)) {
                this.traceUnsupportedDataType(event);
                return;
            }
            if (event.data == null) {
                this.traceMissingEventData(event);
                event.detail = 0;
                return;
            }
            if (!this.dropTargetIsValid(event, true)) {
                event.detail = 0;
                return;
            }
            final String url = this.getUrl(event.data);
            if (MarketplaceDropAdapter.this.acceptSolutionUrl(url)) {
                DropTarget source = (DropTarget)event.getSource();
                Display display = source.getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        MarketplaceDropAdapter.this.proceedInstallation(url);
                    }
                });
            } else if (MarketplaceDropAdapter.this.acceptFavoritesListUrl(url)) {
                DropTarget source = (DropTarget)event.getSource();
                Display display = source.getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        MarketplaceDropAdapter.this.proceedFavorites(url);
                    }
                });
            } else {
                this.traceInvalidEventData(event);
            }
        }

        private void traceDropOperation(int op) {
            if (MarketplaceClientUiPlugin.DEBUG) {
                MarketplaceClientUiPlugin.trace("/debug/dnd", "Updating drop event: Setting drop operation to {0}", op);
            }
        }

        private void traceInvalidEventData(DropTargetEvent event) {
            if (MarketplaceClientUiPlugin.DEBUG) {
                MarketplaceClientUiPlugin.trace("/debug/dnd", "Drop event: Data is not a solution url: {0}", event.data, new Throwable());
            }
        }

        private void traceMissingEventData(DropTargetEvent event) {
            if (MarketplaceClientUiPlugin.DEBUG) {
                MarketplaceClientUiPlugin.trace("/debug/dnd", "Missing drop event data {0}", event.data, new Throwable());
            }
        }

        private void traceUnsupportedDataType(DropTargetEvent event) {
            if (MarketplaceClientUiPlugin.DEBUG) {
                MarketplaceClientUiPlugin.trace("/debug/dnd", "Unsupported drop data type {0}", this.traceTransferData(event.currentDataType), new Throwable());
            }
        }

        private Object traceTransferData(TransferData data) {
            if (MarketplaceClientUiPlugin.DEBUG) {
                return new TransferDataTraceFormatter(data);
            }
            return null;
        }

        private String getUrl(Object eventData) {
            if (eventData == null) {
                return null;
            }
            if (eventData == null || !(eventData instanceof String)) {
                return null;
            }
            String[] dataLines = ((String)eventData).split(System.getProperty("line.separator"));
            String url = dataLines[0];
            return url;
        }
    }

    private static final class TransferDataTraceFormatter {
        private static final Field TYPE_FIELD;
        private final TransferData transferData;

        static {
            Field typeField = null;
            try {
                typeField = TransferData.class.getDeclaredField("type");
                typeField.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            TYPE_FIELD = typeField;
        }

        public TransferDataTraceFormatter(TransferData transferData) {
            this.transferData = transferData;
        }

        public String toString() {
            if (this.transferData == null) {
                return null;
            }
            return "TransferData[type=" + this.getType() + "]";
        }

        private String getType() {
            if (TYPE_FIELD == null) {
                return "<unknown>";
            }
            try {
                Object type = TYPE_FIELD.get(this.transferData);
                return type == null ? null : type.toString();
            }
            catch (IllegalArgumentException e) {
                return "<unknown:" + this.transferData.getClass() + ">";
            }
            catch (IllegalAccessException e) {
                return "<inaccessible>";
            }
        }
    }

    private class WorkbenchListener
    implements IPartListener2,
    IPageListener,
    IPerspectiveListener,
    IWindowListener {
        private WorkbenchListener() {
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            this.pageChanged(page);
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }

        public void pageActivated(IWorkbenchPage page) {
            this.pageChanged(page);
        }

        public void pageClosed(IWorkbenchPage page) {
        }

        public void pageOpened(IWorkbenchPage page) {
            this.pageChanged(page);
        }

        private void pageChanged(IWorkbenchPage page) {
            if (page == null) {
                return;
            }
            IWorkbenchWindow workbenchWindow = page.getWorkbenchWindow();
            this.windowChanged(workbenchWindow);
        }

        public void windowActivated(IWorkbenchWindow window) {
            this.windowChanged(window);
        }

        private void windowChanged(IWorkbenchWindow window) {
            if (window == null) {
                return;
            }
            Shell shell = window.getShell();
            this.runUpdate(shell);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            this.hookWindow(window);
        }

        public void hookWindow(IWorkbenchWindow window) {
            if (window == null) {
                return;
            }
            window.addPageListener((IPageListener)this);
            window.addPerspectiveListener((IPerspectiveListener)this);
            IPartService partService = (IPartService)window.getService(IPartService.class);
            partService.addPartListener((IPartListener2)this);
            this.windowChanged(window);
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            this.partUpdate(partRef);
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            this.partUpdate(partRef);
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
            this.partUpdate(partRef);
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            this.partUpdate(partRef);
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
            this.partUpdate(partRef);
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            this.partUpdate(partRef);
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        private void partUpdate(IWorkbenchPartReference partRef) {
            if (partRef == null) {
                return;
            }
            IWorkbenchPage page = partRef.getPage();
            this.pageChanged(page);
        }

        private void runUpdate(final Shell shell) {
            if (shell == null || shell.isDisposed()) {
                return;
            }
            Display display = shell.getDisplay();
            if (display == null || display.isDisposed()) {
                return;
            }
            try {
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!shell.isDisposed()) {
                            MarketplaceDropAdapter.this.installDropTarget(shell);
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 45) {
                    return;
                }
                MarketplaceClientUi.error(ex);
            }
            catch (RuntimeException ex) {
                MarketplaceClientUi.error(ex);
            }
        }
    }
}

