/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.presentable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.emf.core.ModelUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IAllowedContentsETypedElementSelectionDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IAllowedContentsETypedElementSelectionDialogCallback;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IMustRemoveNonConformingElementsDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.BasicCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.TableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.CustomizationUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.FacetsUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.presentable.AllowedContentsETypedElementSelectionDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.presentable.MustRemoveNonConformingElementsPromptDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.presentable.PresentableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.presentable.SynchronizedMustRemoveNonConformingElementsPromptDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.presentable.SynchronizedPresentabilityETypedElementSelectionDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils.DialogUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentableService {
    private final Table table;
    private final EditingDomain editingDomain;
    private final PresentableCommandFactory presentCmdFactory;

    public PresentableService(Table table, BasicCommandFactory basicCmdFactory, TableCommandFactory tableCmdFactory) {
        this.table = table;
        this.presentCmdFactory = new PresentableCommandFactory(table, basicCmdFactory, tableCmdFactory);
        this.editingDomain = basicCmdFactory.getEditingDomain();
    }

    public void setCanBePresentedInTheTable(ETypedElement presentableQuery, boolean removeNonConform) {
        PresentableService.checkPresentableQuery(presentableQuery);
        Command cmd = this.presentCmdFactory.createSetCanBePresentedInTheTableCommand(presentableQuery, removeNonConform);
        this.editingDomain.getCommandStack().execute(cmd);
    }

    private static void checkPresentableQuery(ETypedElement presentableQuery) {
        if (presentableQuery != null) {
            if (!ModelUtils.isBooleanDataType((EClassifier)presentableQuery.getEType())) {
                throw new IllegalArgumentException("The presentability query must return a boolean");
            }
            if (presentableQuery.getUpperBound() > 1 || presentableQuery.getUpperBound() == -1 || presentableQuery.getLowerBound() > 1) {
                throw new IllegalArgumentException("The presentability query must be single-valued");
            }
            EObject eContainer = presentableQuery.eContainer();
            if (eContainer instanceof Facet && ((Facet)eContainer).getExtendedMetaclass() != EcorePackage.eINSTANCE.getEObject()) {
                throw new IllegalArgumentException("The presentability query must be contained in a Facet extending EObject");
            }
        }
    }

    public IAllowedContentsETypedElementSelectionDialog openCanBePresentedInTheTableDialog(Shell shell) {
        IAllowedContentsETypedElementSelectionDialogCallback callBack = new IAllowedContentsETypedElementSelectionDialogCallback(){

            public boolean mustAskToRemoveNonAllowedElements(ETypedElement allwdCntntTypElt) {
                return !PresentableService.this.containsOnlyPresentableElements(allwdCntntTypElt);
            }

            public void committed(ETypedElement typedElement, boolean rmvNonAllowCntnt) {
                PresentableService.this.setCanBePresentedInTheTable(typedElement, rmvNonAllowCntnt);
            }

            public void canceled() {
            }
        };
        List<ETypedElement> allKnownETypElts = FacetsUtils.getAllKnownETypedElements(this.table);
        ICustomizationManager customManager = CustomizationUtils.getCustomManager((EObject)this.table);
        final AllowedContentsETypedElementSelectionDialog dialog = new AllowedContentsETypedElementSelectionDialog(shell, allKnownETypElts, callBack, customManager);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                dialog.open();
                dialog.select(PresentableService.this.getPresentabilityQuery());
            }
        });
        return new SynchronizedPresentabilityETypedElementSelectionDialog(dialog, shell.getDisplay());
    }

    public List<ETypedElement> getApplicableCanBePresentedQueries() {
        ArrayList<ETypedElement> applicableQueries = new ArrayList<ETypedElement>();
        for (FacetSet facetSet : FacetsUtils.getAllKnownFacetSets(this.table)) {
            for (Facet facet : FacetUtils.getFacets((FacetSet)facetSet)) {
                if (facet.getExtendedMetaclass() != EcorePackage.eINSTANCE.getEObject()) continue;
                applicableQueries.addAll(PresentableService.getCheckedTypeElements(facet));
            }
        }
        return Collections.unmodifiableList(applicableQueries);
    }

    private static List<ETypedElement> getCheckedTypeElements(Facet facet) {
        ArrayList<ETypedElement> result = new ArrayList<ETypedElement>();
        ArrayList typeEltsToChck = new ArrayList();
        typeEltsToChck.addAll(facet.getFacetElements());
        typeEltsToChck.addAll(facet.getFacetOperations());
        for (ETypedElement eTypeElement : typeEltsToChck) {
            if (!ModelUtils.isBooleanDataType((EClassifier)eTypeElement.getEType())) continue;
            result.add(eTypeElement);
        }
        return result;
    }

    public ETypedElement getPresentabilityQuery() {
        TableConfiguration tableConfig;
        ETypedElement presentableQuery = this.table.getCanBePresentedInTheTable();
        if (presentableQuery == null && (tableConfig = this.table.getTableConfiguration()) != null) {
            presentableQuery = tableConfig.getCanBePresentedInTheTable();
        }
        return presentableQuery;
    }

    public IMustRemoveNonConformingElementsDialog setCanBePresentedInTheTable(final ETypedElement presentableQuery, final Shell shell) {
        SynchronizedMustRemoveNonConformingElementsPromptDialog result = null;
        if (this.containsOnlyPresentableElements(presentableQuery)) {
            this.setCanBePresentedInTheTable(presentableQuery, false);
        } else {
            final MustRemoveNonConformingElementsPromptDialog dialog = new MustRemoveNonConformingElementsPromptDialog(shell);
            dialog.addCloseListener(new Runnable(){

                public void run() {
                    try {
                        PresentableService.this.setCanBePresentedInTheTable(presentableQuery, dialog.getMustRemoveNonConformingElements());
                    }
                    catch (Exception e) {
                        DialogUtils.logAndDisplayException(e, shell);
                    }
                }
            });
            dialog.open();
            result = new SynchronizedMustRemoveNonConformingElementsPromptDialog(dialog);
        }
        return result;
    }

    public boolean containsOnlyPresentableElements(ETypedElement presentableQuery) {
        boolean allPresentable = true;
        EList rows = this.table.getRows();
        for (Row row : rows) {
            EObject element = row.getElement();
            if (this.acceptsElement(element, presentableQuery)) continue;
            allPresentable = false;
            break;
        }
        return allPresentable;
    }

    public boolean acceptsElement(Object element, ETypedElement presentableQuery) {
        return this.presentCmdFactory.acceptsElement(element, presentableQuery);
    }

    public boolean acceptsElement(Object element) {
        ETypedElement presentableQuery = this.getPresentabilityQuery();
        return this.acceptsElement(element, presentableQuery);
    }

    public Table getTable() {
        return this.table;
    }
}

