/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.common.sdk.core.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.common.sdk.core.internal.Activator;
import org.eclipse.emf.facet.common.sdk.core.internal.exported.IEmfFacetProjectBuilder;
import org.eclipse.emf.facet.util.core.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfFacetProjectBuilder
extends IncrementalProjectBuilder {
    private static ArrayList<BuilderDescriptor> emffacetBuilders = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmfFacetProjectBuilder() {
        if (emffacetBuilders == null) {
            ArrayList<BuilderDescriptor> arrayList = emffacetBuilders = new ArrayList();
            synchronized (arrayList) {
                IConfigurationElement[] configs;
                IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.facet.common.sdk.core.builderRegistration");
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement config = iConfigurationElementArray[n2];
                    try {
                        String id = config.getDeclaringExtension().getUniqueIdentifier();
                        IEmfFacetProjectBuilder builderInst = (IEmfFacetProjectBuilder)config.createExecutableExtension("class");
                        BuilderDescriptor builderDescriptor = new BuilderDescriptor(builderInst, id);
                        emffacetBuilders.add(builderDescriptor);
                        IConfigurationElement[] iConfigurationElementArray2 = config.getChildren("depends");
                        int n3 = iConfigurationElementArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement depends = iConfigurationElementArray2[n4];
                            builderDescriptor.getDependsOn().add(depends.getAttribute("builder"));
                            ++n4;
                        }
                    }
                    catch (Exception e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                    ++n2;
                }
                emffacetBuilders = EmfFacetProjectBuilder.sortBuilders(emffacetBuilders);
            }
        }
        EmfFacetProjectBuilder.validateBuilderDependencies();
    }

    private static ArrayList<BuilderDescriptor> sortBuilders(ArrayList<BuilderDescriptor> builders) {
        ArrayList<BuilderDescriptor> result = new ArrayList<BuilderDescriptor>();
        LinkedList<BuilderDescriptor> remaining = new LinkedList<BuilderDescriptor>();
        remaining.addAll(builders);
        while (!remaining.isEmpty()) {
            boolean stuck = true;
            ListIterator listIterator = remaining.listIterator();
            while (listIterator.hasNext()) {
                BuilderDescriptor builder = (BuilderDescriptor)listIterator.next();
                if (!EmfFacetProjectBuilder.dependendsOnlyOn(builder, result)) continue;
                result.add(builder);
                listIterator.remove();
                stuck = false;
            }
            if (!stuck) continue;
            throw new RuntimeException("Cannot order builders due to incoherent dependencies");
        }
        return result;
    }

    private static boolean dependendsOnlyOn(BuilderDescriptor builder, ArrayList<BuilderDescriptor> list) {
        List<String> dependsOn = builder.getDependsOn();
        for (String dep : dependsOn) {
            boolean found = false;
            for (BuilderDescriptor prev : list) {
                if (!prev.getId().equals(dep)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static void validateBuilderDependencies() {
        ArrayList<String> idList = new ArrayList<String>();
        for (BuilderDescriptor descriptor : emffacetBuilders) {
            idList.add(descriptor.getId());
        }
        for (BuilderDescriptor descriptor : emffacetBuilders) {
            for (String dependsOn : descriptor.getDependsOn()) {
                if (idList.contains(dependsOn)) continue;
                Logger.logWarning((String)("The builder " + descriptor.getId() + " depends on " + dependsOn + " which does not exist."), (Plugin)Activator.getDefault());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean(IProgressMonitor monitor) throws CoreException {
        ArrayList<BuilderDescriptor> arrayList = emffacetBuilders;
        synchronized (arrayList) {
            for (BuilderDescriptor builder : emffacetBuilders) {
                builder.getBuilderInst().clean(this, monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        ArrayList<BuilderDescriptor> arrayList = emffacetBuilders;
        synchronized (arrayList) {
            for (BuilderDescriptor builder : emffacetBuilders) {
                builder.getBuilderInst().build(this, kind, args, monitor);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuilderDescriptor {
        private final IEmfFacetProjectBuilder builderInst;
        private final List<String> dependsOn = new ArrayList<String>();
        private final String id;

        public BuilderDescriptor(IEmfFacetProjectBuilder builderInst, String id) {
            this.builderInst = builderInst;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getDependsOn() {
            return this.dependsOn;
        }

        public IEmfFacetProjectBuilder getBuilderInst() {
            return this.builderInst;
        }

        public String toString() {
            return String.valueOf(this.id) + "(" + this.builderInst.getClass().getName() + ")";
        }
    }
}

