/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.lang.reflect.Field;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareContentViewerSwitchingPane;
import org.eclipse.compare.internal.CompareEditorInputNavigator;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.egerrit.internal.ui.compare.AnnotationContributionItems;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;

class UICompareUtils {
    static final String NEXT_COMMENT_ANNOTATION_COMMAND = "org.eclipse.egerrit.internal.ui.compare.NextCommentAnnotationHandler";
    static final String NEXT_COMMENT_ANNOTATION_COMMAND_MNEMONIC = "N";
    static final String PREVIOUS_COMMENT_ANNOTATION_COMMAND = "org.eclipse.egerrit.internal.ui.compare.PreviousCommentAnnotationHandler";
    static final String PREVIOUS_COMMENT_ANNOTATION_COMMAND_MNEMONIC = "P";
    private static final String COMPARE_EDITOR_TEXT_CLASS_NAME = "org.eclipse.compare.contentmergeviewer.TextMergeViewer";
    private static final String COMPARE_EDITOR_TEXT_FIELD_LEFT = "fLeft";
    private static final String COMPARE_EDITOR_TEXT_FIELD_RIGHT = "fRight";
    private static final String DEFAULT_OBJECT_CLASS_NAME = "Object";
    private static final String MIRRORED_PROPERTY = "MIRRORED";

    private UICompareUtils() {
    }

    static void insertAnnotationNavigationCommands(IToolBarManager aManager) {
        IContributionItem[] items;
        aManager.add((IContributionItem)new Separator());
        AnnotationContributionItems itemsManager = new AnnotationContributionItems();
        IContributionItem[] iContributionItemArray = items = itemsManager.getallContributionItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            aManager.add(item);
            ++n2;
        }
        aManager.update(true);
    }

    public static MergeSourceViewer extractMergeSourceViewer(ICompareNavigator aNavigator, boolean getLeftPane) {
        if (aNavigator instanceof CompareEditorInputNavigator) {
            Object[] panes;
            Object[] objectArray = panes = ((CompareEditorInputNavigator)aNavigator).getPanes();
            int n = panes.length;
            int n2 = 0;
            while (n2 < n) {
                Viewer viewer;
                Object pane = objectArray[n2];
                if (pane instanceof CompareContentViewerSwitchingPane && (viewer = ((CompareContentViewerSwitchingPane)pane).getViewer()) instanceof TextMergeViewer) {
                    TextMergeViewer textViewer = (TextMergeViewer)viewer;
                    Class<?> textViewerClass = textViewer.getClass();
                    if (!textViewerClass.getName().equals(COMPARE_EDITOR_TEXT_CLASS_NAME)) {
                        while (!(textViewerClass = textViewerClass.getSuperclass()).getName().equals(DEFAULT_OBJECT_CLASS_NAME) && !textViewerClass.getName().equals(COMPARE_EDITOR_TEXT_CLASS_NAME)) {
                        }
                    }
                    try {
                        Field field = getLeftPane ? textViewerClass.getDeclaredField(COMPARE_EDITOR_TEXT_FIELD_LEFT) : textViewerClass.getDeclaredField(COMPARE_EDITOR_TEXT_FIELD_RIGHT);
                        field.setAccessible(true);
                        return (MergeSourceViewer)field.get(textViewer);
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    static boolean isMirroredOn(CompareEditorInput input) {
        return Boolean.TRUE.equals(input.getCompareConfiguration().getProperty(MIRRORED_PROPERTY));
    }
}

