/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.launch;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.launchbar.core.ILaunchBarListener;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public class CoreBuildLaunchBarTracker
implements ILaunchBarListener {
    private final ILaunchBarManager launchBarManager = CDebugCorePlugin.getService(ILaunchBarManager.class);
    private final ICBuildConfigurationManager configManager = CDebugCorePlugin.getService(ICBuildConfigurationManager.class);
    private final IToolChainManager toolChainManager = CDebugCorePlugin.getService(IToolChainManager.class);
    private ILaunchMode lastMode;
    private ILaunchDescriptor lastDescriptor;
    private ILaunchTarget lastTarget;

    private void setActiveBuildConfig(final ILaunchMode mode, ILaunchDescriptor descriptor, final ILaunchTarget target) throws CoreException {
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project == null) {
            IResource[] mappedResources;
            ILaunchConfiguration configuration = this.launchBarManager.getLaunchConfiguration(descriptor, target);
            if (configuration == null) {
                return;
            }
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (!projectName.isEmpty()) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            if (project == null && (mappedResources = configuration.getMappedResources()) != null && mappedResources.length > 0) {
                project = mappedResources[0].getProject();
            }
        }
        if (project == null || !this.configManager.supports(project)) {
            return;
        }
        final IProject finalProject = project;
        this.lastMode = mode;
        this.lastDescriptor = descriptor;
        this.lastTarget = target;
        Job job = new Job(InternalDebugCoreMessages.CoreBuildLaunchBarTracker_Job){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashMap properties = new HashMap();
                    properties.putAll(target.getAttributes());
                    Collection tcs = CoreBuildLaunchBarTracker.this.toolChainManager.getToolChainsMatching(properties);
                    if (!tcs.isEmpty()) {
                        IToolChain toolChain = (IToolChain)tcs.iterator().next();
                        ICBuildConfiguration buildConfig = CoreBuildLaunchBarTracker.this.configManager.getBuildConfiguration(finalProject, toolChain, mode.getIdentifier(), monitor);
                        if (buildConfig != null && !buildConfig.getBuildConfiguration().equals(finalProject.getActiveBuildConfig())) {
                            IProjectDescription desc = finalProject.getDescription();
                            desc.setActiveBuildConfig(buildConfig.getBuildConfiguration().getName());
                            finalProject.setDescription(desc, monitor);
                        }
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        };
        job.setRule((ISchedulingRule)project.getWorkspace().getRoot());
        job.schedule();
    }

    public void activeLaunchTargetChanged(ILaunchTarget target) {
        try {
            if (target == null || target.equals(ILaunchTarget.NULL_TARGET) || target.equals(this.lastTarget)) {
                return;
            }
            ILaunchMode mode = this.launchBarManager.getActiveLaunchMode();
            if (mode == null) {
                return;
            }
            ILaunchDescriptor descriptor = this.launchBarManager.getActiveLaunchDescriptor();
            this.setActiveBuildConfig(mode, descriptor, target);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }

    public void activeLaunchDescriptorChanged(ILaunchDescriptor descriptor) {
        try {
            if (descriptor == null || descriptor.equals(this.lastDescriptor)) {
                return;
            }
            ILaunchMode mode = this.launchBarManager.getActiveLaunchMode();
            if (mode == null) {
                return;
            }
            ILaunchTarget target = this.launchBarManager.getActiveLaunchTarget();
            this.setActiveBuildConfig(mode, descriptor, target);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }

    public void activeLaunchModeChanged(ILaunchMode mode) {
        try {
            if (mode == null || mode.equals(this.lastMode)) {
                return;
            }
            ILaunchDescriptor descriptor = this.launchBarManager.getActiveLaunchDescriptor();
            ILaunchTarget target = this.launchBarManager.getActiveLaunchTarget();
            this.setActiveBuildConfig(mode, descriptor, target);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }
}

