/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.hive.ui.profile;

import java.util.Properties;
import org.eclipse.birt.report.data.oda.hive.ui.i18n.Messages;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.dialogs.JdbcDriverManagerDialog;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DriverLoader;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class HiveSelectionPageHelper {
    private WizardPage m_wizardPage;
    private PreferencePage m_propertyPage;
    private Button manageButton;
    private Button testButton;
    private static final String EMPTY_URL = JdbcPlugin.getResourceString((String)"error.emptyDatabaseUrl");
    private final String CONEXT_ID_DATASOURCE_HIVE = "org.eclipse.birt.cshelp.Wizard_DatasourceProfile_ID";
    private Label m_driverClass;
    private Label m_driverURL;
    private Label m_User;
    private Text jdbcUrl;
    private Text userName;
    private Text password;
    private Text jndiName;
    private Text addfile;
    private String DEFAULT_MESSAGE = "";
    private static final String EMPTY_STRING = "";

    public HiveSelectionPageHelper(WizardPage page, String odaDesignerID) {
        this.m_wizardPage = page;
        this.setDefaultMessage(odaDesignerID);
    }

    public HiveSelectionPageHelper(PreferencePage page, String odaDesignerID) {
        this.m_propertyPage = page;
        this.setDefaultMessage(odaDesignerID);
    }

    private void setDefaultMessage(String odaDesignerID) {
        String msgExpr = Messages.getMessage("datasource.page.title");
        String dsMsgExpr = msgExpr.replace("odadesignerid", odaDesignerID);
        IStringVariableManager varMgr = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            this.DEFAULT_MESSAGE = varMgr.performStringSubstitution(dsMsgExpr, false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    void createCustomControl(Composite parent) {
        ScrolledComposite scrollContent = new ScrolledComposite(parent, 768);
        scrollContent.setAlwaysShowScrollBars(false);
        scrollContent.setExpandHorizontal(true);
        scrollContent.setLayout((Layout)new FillLayout());
        Composite content = new Composite((Composite)scrollContent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.verticalSpacing = 10;
        layout.marginBottom = 10;
        content.setLayout((Layout)layout);
        new Label(content, 16384).setText(Messages.getMessage("datasource.page.driver.class"));
        this.m_driverClass = new Label(content, 16384);
        this.m_driverClass.setText("org.apache.hive.jdbc.HiveDriver");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_driverClass.setLayoutData((Object)gridData);
        new Label(content, 131072).setText(JdbcPlugin.getResourceString((String)"wizard.label.url"));
        this.jdbcUrl = new Text(content, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.jdbcUrl.setLayoutData((Object)gridData);
        this.jdbcUrl.setText("jdbc:hive2://localhost:10000/default");
        new Label(content, 131072).setText(JdbcPlugin.getResourceString((String)"wizard.label.username"));
        this.userName = new Text(content, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.userName.setLayoutData((Object)gridData);
        new Label(content, 131072).setText(JdbcPlugin.getResourceString((String)"wizard.label.password"));
        this.password = new Text(content, 0x400800);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.password.setLayoutData((Object)gridData);
        new Label(content, 131072).setText(Messages.getMessage("datasource.addfile"));
        this.addfile = new Text(content, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.addfile.setLayoutData((Object)gridData);
        this.manageButton = new Button(content, 8);
        this.manageButton.setText(JdbcPlugin.getResourceString((String)"wizard.label.manageDriver"));
        this.testButton = new Button(content, 8);
        this.testButton.setText(JdbcPlugin.getResourceString((String)"wizard.label.testConnection"));
        this.testButton.setLayoutData((Object)new GridData(2));
        Point size = content.computeSize(-1, -1);
        content.setSize(size.x, size.y);
        scrollContent.setMinWidth(size.x + 10);
        scrollContent.setContent((Control)content);
        this.addControlListeners();
        this.updateTestButton();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.birt.cshelp.Wizard_DatasourceProfile_ID");
    }

    Properties collectCustomProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("odaDriverClass", this.getDriverClass());
        props.setProperty("odaURL", this.getDriverURL());
        props.setProperty("odaUser", this.getODAUser());
        props.setProperty("odaPassword", this.getODAPassword());
        props.setProperty("addListFile", this.getAddFile());
        return props;
    }

    private String getODAUser() {
        if (this.userName == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.userName.getText());
    }

    private String getODAPassword() {
        if (this.password == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.password.getText());
    }

    private String getDriverURL() {
        if (this.jdbcUrl == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.jdbcUrl.getText());
    }

    private String getAddFile() {
        if (this.addfile == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.addfile.getText());
    }

    private String getTrimedString(String tobeTrimed) {
        if (tobeTrimed != null) {
            tobeTrimed = tobeTrimed.trim();
        }
        return tobeTrimed;
    }

    private String getDriverClass() {
        return "org.apache.hive.jdbc.HiveDriver";
    }

    void initCustomControl(Properties profileProps) {
        if (profileProps == null || profileProps.isEmpty()) {
            return;
        }
        String driverClass = profileProps.getProperty("odaDriverClass");
        if (driverClass == null) {
            driverClass = EMPTY_STRING;
        }
        this.m_driverClass.setText(driverClass);
        String driverUrl = profileProps.getProperty("odaURL");
        if (driverUrl == null) {
            driverUrl = EMPTY_STRING;
        }
        this.jdbcUrl.setText(driverUrl);
        String user = profileProps.getProperty("odaUser");
        if (user == null) {
            user = EMPTY_STRING;
        }
        this.userName.setText(user);
        String odaPassword = profileProps.getProperty("odaPassword");
        if (odaPassword == null) {
            odaPassword = EMPTY_STRING;
        }
        this.password.setText(odaPassword);
        String addFile = profileProps.getProperty("addListFile");
        if (addFile == null) {
            addFile = EMPTY_STRING;
        }
        this.addfile.setText(addFile);
    }

    private void setMessage(String message) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(message);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setMessage(message);
        }
    }

    private Control getControl() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getControl();
        }
        assert (this.m_propertyPage != null);
        return this.m_propertyPage.getControl();
    }

    private void addControlListeners() {
        this.jdbcUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!HiveSelectionPageHelper.this.jdbcUrl.isFocusControl() && HiveSelectionPageHelper.this.jdbcUrl.getText().trim().length() == 0) {
                    return;
                }
                HiveSelectionPageHelper.this.verifyJDBCProperties();
                HiveSelectionPageHelper.this.updateTestButton();
            }
        });
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HiveSelectionPageHelper.this.testButton.setEnabled(false);
                try {
                    if (HiveSelectionPageHelper.this.testConnection()) {
                        MessageDialog.openInformation((Shell)HiveSelectionPageHelper.this.getShell(), (String)JdbcPlugin.getResourceString((String)"connection.test"), (String)JdbcPlugin.getResourceString((String)"connection.success"));
                    } else {
                        OdaException ex = new OdaException(JdbcPlugin.getResourceString((String)"connection.failed"));
                        ExceptionHandler.showException((Shell)HiveSelectionPageHelper.this.getShell(), (String)JdbcPlugin.getResourceString((String)"connection.test"), (String)JdbcPlugin.getResourceString((String)"connection.failed"), (Throwable)ex);
                    }
                }
                catch (OdaException e1) {
                    ExceptionHandler.showException((Shell)HiveSelectionPageHelper.this.getShell(), (String)JdbcPlugin.getResourceString((String)"connection.test"), (String)JdbcPlugin.getResourceString((String)e1.getLocalizedMessage()), (Throwable)e1);
                }
                HiveSelectionPageHelper.this.testButton.setEnabled(true);
            }
        });
        this.manageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JdbcDriverManagerDialog dlg = new JdbcDriverManagerDialog(HiveSelectionPageHelper.this.getShell());
                HiveSelectionPageHelper.this.manageButton.setEnabled(false);
                HiveSelectionPageHelper.this.testButton.setEnabled(false);
                if (dlg.open() == 0) {
                    BusyIndicator.showWhile((Display)(HiveSelectionPageHelper.this.getShell() == null ? null : HiveSelectionPageHelper.this.getShell().getDisplay()), (Runnable)new Runnable(){

                        public void run() {
                            HiveSelectionPageHelper.this.okPressedProcess();
                        }
                    });
                }
                HiveSelectionPageHelper.this.updateTestButton();
                HiveSelectionPageHelper.this.manageButton.setEnabled(true);
            }
        });
    }

    private void okPressedProcess() {
    }

    private boolean testConnection() throws OdaException {
        if (!this.isValidDataSource()) {
            return false;
        }
        String url = this.jdbcUrl.getText().trim();
        String userid = this.userName.getText().trim();
        String passwd = this.password.getText();
        String driverName = "org.apache.hive.jdbc.HiveDriver";
        return DriverLoader.testConnection((String)driverName, (String)url, null, (String)userid, (String)passwd);
    }

    private boolean isValidDataSource() {
        return !this.isURLBlank();
    }

    private boolean isURLBlank() {
        return this.jdbcUrl == null || this.jdbcUrl.getText().trim().length() == 0;
    }

    private Shell getShell() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getShell();
        }
        if (this.m_propertyPage != null) {
            return this.m_propertyPage.getShell();
        }
        return null;
    }

    private void updateTestButton() {
        if (this.isURLBlank()) {
            this.setMessage(EMPTY_URL, 3);
            this.testButton.setEnabled(false);
        } else {
            this.setMessage(this.DEFAULT_MESSAGE);
            if (!this.testButton.isEnabled()) {
                this.testButton.setEnabled(true);
            }
        }
    }

    void resetTestButton() {
        this.updateTestButton();
        this.enableParent((Control)this.testButton);
    }

    private void enableParent(Control control) {
        Composite parent = control.getParent();
        if (parent == null || parent instanceof Shell) {
            return;
        }
        if (!parent.isEnabled()) {
            parent.setEnabled(true);
        }
        this.enableParent((Control)parent);
    }

    private void setMessage(String message, int type) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(message, type);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setMessage(message, type);
        }
    }

    private void verifyJDBCProperties() {
        if (!this.isURLBlank()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private void setPageComplete(boolean complete) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setPageComplete(complete);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setValid(complete);
        }
    }
}

