/***********************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Actuate Corporation - initial API and implementation
 ***********************************************************************/

package org.eclipse.birt.chart.examples.view.models;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineDecorator;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.GradientImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.DialRegion;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.DialRegionImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.DialChartImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.impl.DialSeriesImpl;

public class SDialSRegionMeter
{

	public static final Chart createSDialSRegionMeter( )
	{
		DialChart dChart = (DialChart) DialChartImpl.create( );
		dChart.setType( "Meter Chart" ); //$NON-NLS-1$	
		dChart.setSubType( "Standard Meter Chart" ); //$NON-NLS-1$
		
		dChart.setDialSuperimposition( false );
		dChart.setGridColumnCount( 2 );
		dChart.setSeriesThickness( 25 );

		// Title/Plot
		dChart.getBlock( ).setBackground( ColorDefinitionImpl.WHITE( ) );
		dChart.getPlot( )
				.getClientArea( )
				.setBackground( ColorDefinitionImpl.create( 255, 255, 225 ) );

		dChart.getTitle( )
				.getLabel( )
				.getCaption( )
				.setValue( "Single Dial Single Region Meter Chart" );//$NON-NLS-1$
		dChart.getTitle( ).getOutline( ).setVisible( false );

		// Legend
		Legend lg = dChart.getLegend( );
		LineAttributes lia = lg.getOutline( );
		lg.getText( ).getFont( ).setSize( 16 );
		lia.setStyle( LineStyle.SOLID_LITERAL );
		lg.getInsets( ).setLeft( 10 );
		lg.getInsets( ).setRight( 10 );
		lg.getOutline( ).setVisible( false );
		lg.setShowValue( true );
		lg.getClientArea( ).setBackground( ColorDefinitionImpl.PINK( ) );

		lg.getClientArea( ).getOutline( ).setVisible( true );
		lg.getTitle( ).getCaption( ).getFont( ).setSize( 20 );
		lg.getTitle( ).setInsets( InsetsImpl.create( 10, 10, 10, 10 ) );
		lg.setTitlePosition( Position.ABOVE_LITERAL );

		// Data Set
		TextDataSet categoryValues = TextDataSetImpl.create( new String[]{
			"Speed"} );//$NON-NLS-1$
		
		SampleData sdata = DataFactory.eINSTANCE.createSampleData( );
		BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData( );
		sdBase.setDataSetRepresentation( "" );//$NON-NLS-1$
		sdata.getBaseSampleData( ).add( sdBase );

		OrthogonalSampleData sdOrthogonal = DataFactory.eINSTANCE.createOrthogonalSampleData( );
		sdOrthogonal.setDataSetRepresentation( "" );//$NON-NLS-1$
		sdOrthogonal.setSeriesDefinitionIndex( 0 );
		sdata.getOrthogonalSampleData( ).add( sdOrthogonal );
		
		dChart.setSampleData( sdata );

		SeriesDefinition sd = SeriesDefinitionImpl.create( );
		dChart.getSeriesDefinitions( ).add( sd );
		Series seCategory = (Series) SeriesImpl.create( );

		final Fill[] fiaBase = {
				ColorDefinitionImpl.ORANGE( ),
				GradientImpl.create( ColorDefinitionImpl.create( 225, 225, 255 ),
						ColorDefinitionImpl.create( 255, 255, 225 ),
						-35,
						false ),
				ColorDefinitionImpl.CREAM( ),
				ColorDefinitionImpl.RED( ),
				ColorDefinitionImpl.GREEN( ),
				ColorDefinitionImpl.BLUE( ).brighter( ),
				ColorDefinitionImpl.CYAN( ).darker( ),
		};
		sd.getSeriesPalette( ).getEntries( ).clear( );
		for ( int i = 0; i < fiaBase.length; i++ )
		{
			sd.getSeriesPalette( ).getEntries( ).add( fiaBase[i] );
		}

		seCategory.setDataSet( categoryValues );
		sd.getSeries( ).add( seCategory );

		SeriesDefinition sdCity = SeriesDefinitionImpl.create( );

		// Dial
		DialSeries seDial = (DialSeries) DialSeriesImpl.create( );
		seDial.setDataSet( NumberDataSetImpl.create( new double[]{
			60
		} ) );
		seDial.getDial( )
				.setFill( GradientImpl.create( ColorDefinitionImpl.create( 225,
						225,
						255 ),
						ColorDefinitionImpl.create( 255, 255, 225 ),
						-35,
						false ) );
		seDial.getNeedle( ).setDecorator( LineDecorator.ARROW_LITERAL );
		seDial.getDial( )
				.getMinorGrid( )
				.getTickAttributes( )
				.setVisible( true );
		seDial.getDial( )
				.getMinorGrid( )
				.getTickAttributes( )
				.setColor( ColorDefinitionImpl.RED( ) );
		seDial.getDial( )
				.getMinorGrid( )
				.setTickStyle( TickStyle.BELOW_LITERAL );
		seDial.getDial( )
				.getScale( )
				.setMin( NumberDataElementImpl.create( 0 ) );
		seDial.getDial( )
				.getScale( )
				.setMax( NumberDataElementImpl.create( 180 ) );
		seDial.getDial( ).getScale( ).setStep( 30 );
		seDial.getLabel( )
				.setOutline( LineAttributesImpl.create( ColorDefinitionImpl.GREY( )
						.darker( ),
						LineStyle.SOLID_LITERAL,
						1 ) );
		seDial.getLabel( ).setBackground( ColorDefinitionImpl.GREY( )
				.brighter( ) );

		DialRegion dregion21 = DialRegionImpl.create( );
		dregion21.setFill( ColorDefinitionImpl.GREEN( ) );
		dregion21.setStartValue( NumberDataElementImpl.create( 0 ) );
		dregion21.setEndValue( NumberDataElementImpl.create( 80 ) );
		seDial.getDial( ).getDialRegions( ).add( dregion21 );

		sd.getSeriesDefinitions( ).add( sdCity );
		sdCity.getSeries( ).add( seDial );

		return dChart;
	}

}
