/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.util.converter.impl;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.eclipse.actf.model.dom.odf.ODFParser;
import org.eclipse.actf.model.dom.odf.base.DrawingObjectBaseElement;
import org.eclipse.actf.model.dom.odf.base.EmbedDrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.content.IEditable;
import org.eclipse.actf.model.dom.odf.dr3d.SceneElement;
import org.eclipse.actf.model.dom.odf.draw.CaptionElement;
import org.eclipse.actf.model.dom.odf.draw.CircleElement;
import org.eclipse.actf.model.dom.odf.draw.ConnectorElement;
import org.eclipse.actf.model.dom.odf.draw.ControlElement;
import org.eclipse.actf.model.dom.odf.draw.CustomShapeElement;
import org.eclipse.actf.model.dom.odf.draw.EllipseElement;
import org.eclipse.actf.model.dom.odf.draw.FrameElement;
import org.eclipse.actf.model.dom.odf.draw.GElement;
import org.eclipse.actf.model.dom.odf.draw.ImageElement;
import org.eclipse.actf.model.dom.odf.draw.ImageMapAreaElement;
import org.eclipse.actf.model.dom.odf.draw.ImageMapElement;
import org.eclipse.actf.model.dom.odf.draw.LineElement;
import org.eclipse.actf.model.dom.odf.draw.ObjectElement;
import org.eclipse.actf.model.dom.odf.draw.PageThumbnailElement;
import org.eclipse.actf.model.dom.odf.draw.PolygonElement;
import org.eclipse.actf.model.dom.odf.draw.PolylineElement;
import org.eclipse.actf.model.dom.odf.draw.RectElement;
import org.eclipse.actf.model.dom.odf.draw.RegularPolygonElement;
import org.eclipse.actf.model.dom.odf.draw.TextBoxElement;
import org.eclipse.actf.model.dom.odf.form.FixedTextElement;
import org.eclipse.actf.model.dom.odf.form.FormControlElement;
import org.eclipse.actf.model.dom.odf.table.TableCellElement;
import org.eclipse.actf.model.dom.odf.text.PElement;
import org.eclipse.actf.model.dom.odf.text.PageNumberElement;
import org.eclipse.actf.model.dom.odf.text.SElement;
import org.eclipse.actf.model.dom.odf.text.TabElement;
import org.eclipse.actf.model.dom.odf.text.TrackedChangesElement;
import org.eclipse.actf.model.dom.odf.util.converter.ODFConverterUtils;
import org.eclipse.actf.model.dom.odf.util.converter.TextExtractor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TextExtractorImpl
implements TextExtractor {
    public static final String IMAGE_NO_ALT = "[image]";
    public static final String IMAGEMAP_NO_ALT = "[imagemap]";
    public static final String OBJECT_NO_ALT = "[object]";
    public static final String OBJECT_TABLE = "[table]";
    public static final String TEXTBOX_NO_ALT = "[text box]";
    public static final String CAPTION_NO_ALT = "[caption]";
    public static final String CIRCLE_NO_ALT = "[circle]";
    public static final String CONNECTOR_NO_ALT = "[connector]";
    public static final String CUSTOMSHAPE_NO_ALT = "[custom shape]";
    public static final String ELLIPSE_NO_ALT = "[ellipse]";
    public static final String FRAME_NO_ALT = "[frame]";
    public static final String G_NO_ALT = "[group]";
    public static final String IMAGEMAPAREA_NO_ALT = "[imagemap area]";
    public static final String LINE_NO_ALT = "[line]";
    public static final String POLYGON_NO_ALT = "[polygon]";
    public static final String POLYLINE_NO_ALT = "[polygon line]";
    public static final String RECT_NO_ALT = "[rectangle]";
    public static final String REGULARPOLYGON_NO_ALT = "[polygon]";
    public static final String SCENE_NO_ALT = "[3D shape]";
    public static final String UNKNOWNSHAPE_NO_ALT = "[graphic shape]";
    private TextExtractor converter;
    private double odfVersion = -1.0;
    private ODFElement curElem = null;

    public void setDocument(ODFDocument oDFDocument, TextExtractor textExtractor) {
        this.curElem = (ODFElement)oDFDocument.getDocumentElement();
        this.converter = textExtractor;
    }

    public void setOdfVersion(double d) {
        this.odfVersion = d;
    }

    private boolean writeControlElementContent(Writer writer, ControlElement controlElement) {
        FormControlElement formControlElement = controlElement.getFormControlElement();
        if (formControlElement != null) {
            try {
                String string;
                if (!(formControlElement instanceof FixedTextElement)) {
                    writer.write("[form control]");
                }
                if ((string = formControlElement.getAttrFormLabel()) != null) {
                    if (!(formControlElement instanceof FixedTextElement)) {
                        writer.write(" ");
                    }
                    writer.write(string);
                }
                return true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    private boolean writeFrameElementContent(Writer writer, File file, FrameElement frameElement, boolean bl) {
        ODFElement oDFElement;
        boolean bl2 = false;
        Iterator<ODFElement> iterator = frameElement.getChildIterator();
        if (iterator.hasNext() && (oDFElement = iterator.next()) != null) {
            ODFElement oDFElement2;
            bl2 |= this.converter.extractContent(writer, file, oDFElement, bl);
            if (iterator.hasNext() && (oDFElement2 = iterator.next()) != null && oDFElement2 instanceof ImageMapElement) {
                bl2 |= this.converter.extractContent(writer, file, oDFElement2, bl);
            }
        }
        return bl2;
    }

    private boolean writeImageMapElementContent(Writer writer, File file, ImageMapElement imageMapElement, boolean bl) {
        boolean bl2 = false;
        NodeList nodeList = imageMapElement.getAreaElements();
        int n = 0;
        while (n < nodeList.getLength()) {
            bl2 |= this.converter.extractContent(writer, file, (ImageMapAreaElement)nodeList.item(n), bl);
            ++n;
        }
        return bl2;
    }

    private boolean writeTextBoxElementContent(Writer writer, File file, TextBoxElement textBoxElement, boolean bl) {
        boolean bl2 = false;
        NodeList nodeList = textBoxElement.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Text) {
                String string = ((Text)node).getData().trim();
                if (string.length() != 0) {
                    string = ODFConverterUtils.convertXMLCharacter(string);
                    try {
                        writer.write(string);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    bl2 = true;
                }
            } else if (node instanceof ODFElement) {
                bl2 |= this.converter.extractContent(writer, file, (ODFElement)node, bl);
            }
            ++n;
        }
        return bl2;
    }

    private boolean writeTabElementContent(Writer writer, TabElement tabElement) {
        try {
            writer.write("\t");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    private boolean writeSElementContent(Writer writer, SElement sElement) {
        if (sElement.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "c")) {
            int n = sElement.getAttrTextC();
            if (n > 0) {
                String string = "";
                int n2 = 0;
                while (n2 < n) {
                    string = String.valueOf(string) + " ";
                    ++n2;
                }
                try {
                    writer.write(string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else {
            try {
                writer.write(" ");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return true;
    }

    private boolean writeCustomShapeElementContent(Writer writer, File file, CustomShapeElement customShapeElement, boolean bl) {
        Object object;
        boolean bl2 = false;
        NodeList nodeList = customShapeElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p");
        if (nodeList != null && nodeList.getLength() != 0) {
            int n = 0;
            while (n < nodeList.getLength()) {
                object = nodeList.item(n);
                String string = object.getTextContent();
                if (string != null && string.length() > 0) {
                    bl2 |= this.converter.extractContent(writer, file, (ODFElement)nodeList.item(n), bl);
                }
                ++n;
            }
        }
        if (!bl2) {
            IEditable iEditable = null;
            iEditable = this.odfVersion != -1.0 ? (IEditable)((Object)customShapeElement.getShortDescElement(this.odfVersion)) : (IEditable)((Object)customShapeElement.getShortDescElement());
            if (iEditable == null) {
                object = (ODFDocument)customShapeElement.getOwnerDocument();
                if (object.getODFVersion() > 1.0 || this.odfVersion != -1.0 && this.odfVersion > 1.0) {
                    try {
                        writer.write(CUSTOMSHAPE_NO_ALT);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                bl2 = true;
            } else {
                object = (String)iEditable.getValue();
                if (object != null) {
                    try {
                        writer.write((String)object);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    private boolean writeDrawingObjectBaseElementContent(Writer writer, File file, DrawingObjectBaseElement drawingObjectBaseElement, boolean bl) {
        Object object;
        boolean bl2 = false;
        if (drawingObjectBaseElement instanceof ImageElement) {
            return false;
        }
        if (drawingObjectBaseElement instanceof PageThumbnailElement) {
            return false;
        }
        NodeList nodeList = drawingObjectBaseElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p");
        if (nodeList != null && nodeList.getLength() != 0) {
            int n = 0;
            while (n < nodeList.getLength()) {
                object = nodeList.item(n);
                String string = object.getTextContent();
                if (string != null && string.length() > 0) {
                    bl2 |= this.converter.extractContent(writer, file, (ODFElement)nodeList.item(n), bl);
                }
                ++n;
            }
        }
        if (!bl2) {
            IEditable iEditable = null;
            iEditable = this.odfVersion != -1.0 ? (IEditable)((Object)drawingObjectBaseElement.getShortDescElement(this.odfVersion)) : (IEditable)((Object)drawingObjectBaseElement.getShortDescElement());
            if (iEditable == null) {
                object = (ODFDocument)drawingObjectBaseElement.getOwnerDocument();
                if (drawingObjectBaseElement instanceof EmbedDrawingObjectElement || object.getODFVersion() > 1.0 || this.odfVersion != -1.0 && this.odfVersion > 1.0) {
                    try {
                        if (drawingObjectBaseElement instanceof ImageElement) {
                            writer.write(IMAGE_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof ImageMapElement) {
                            writer.write(IMAGEMAP_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof ObjectElement) {
                            if (((ObjectElement)drawingObjectBaseElement).isPresentationTable()) {
                                writer.write(OBJECT_TABLE);
                            } else {
                                writer.write(OBJECT_NO_ALT);
                            }
                        } else if (drawingObjectBaseElement instanceof CaptionElement) {
                            writer.write(CAPTION_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof TextBoxElement) {
                            writer.write(TEXTBOX_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof CircleElement) {
                            writer.write(CIRCLE_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof ConnectorElement) {
                            writer.write(CONNECTOR_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof CustomShapeElement) {
                            writer.write(CUSTOMSHAPE_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof EllipseElement) {
                            writer.write(ELLIPSE_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof FrameElement) {
                            writer.write(FRAME_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof GElement) {
                            writer.write(G_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof ImageMapAreaElement) {
                            writer.write(IMAGEMAPAREA_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof LineElement) {
                            writer.write(LINE_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof PolygonElement) {
                            writer.write("[polygon]");
                        } else if (drawingObjectBaseElement instanceof PolylineElement) {
                            writer.write(POLYLINE_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof RectElement) {
                            writer.write(RECT_NO_ALT);
                        } else if (drawingObjectBaseElement instanceof RegularPolygonElement) {
                            writer.write("[polygon]");
                        } else if (drawingObjectBaseElement instanceof SceneElement) {
                            writer.write(SCENE_NO_ALT);
                        } else {
                            writer.write(UNKNOWNSHAPE_NO_ALT);
                        }
                        writer.write(System.getProperty("line.separator"));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    bl2 = true;
                }
            } else {
                object = (String)iEditable.getValue();
                if (object != null) {
                    try {
                        writer.write((String)object);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    private boolean writeTableCellElementContent(Writer writer, File file, TableCellElement tableCellElement, boolean bl) {
        boolean bl2 = this.writeODFElementContent(writer, file, tableCellElement, bl);
        if (!bl2) {
            try {
                writer.write("&nbsp;");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return true;
    }

    private boolean writeODFElementContent(Writer writer, File file, ODFElement oDFElement, boolean bl) {
        boolean bl2 = false;
        NodeList nodeList = oDFElement.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Text) {
                String string = ((Text)node).getData().trim();
                if (string.length() != 0) {
                    string = ODFConverterUtils.convertXMLCharacter(string);
                    try {
                        writer.write(string);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    bl2 = true;
                }
            } else if (node instanceof ODFElement) {
                bl2 |= this.converter.extractContent(writer, file, (ODFElement)node, bl);
            }
            ++n;
        }
        return bl2;
    }

    public void extractEmbedFile(ODFElement oDFElement, File file, String string) {
        if (file == null) {
            return;
        }
        String string2 = String.valueOf(file.getAbsolutePath()) + System.getProperty("file.separator") + string;
        File file2 = new File(string2);
        String string3 = file2.getParent();
        File file3 = new File(string3);
        if (!file3.exists()) {
            file3.mkdirs();
        }
        ODFParser oDFParser = new ODFParser();
        Document document = this.curElem.getOwnerDocument();
        if (document instanceof ODFDocument) {
            oDFParser.copyFile(((ODFDocument)document).getURL(), string, string2);
        }
    }

    public boolean extractContent(Writer writer, File file, ODFElement oDFElement, boolean bl) {
        boolean bl2 = false;
        if (oDFElement instanceof TabElement) {
            bl2 |= this.writeTabElementContent(writer, (TabElement)oDFElement);
        } else if (oDFElement instanceof SElement) {
            bl2 |= this.writeSElementContent(writer, (SElement)oDFElement);
        } else if (oDFElement instanceof TableCellElement) {
            bl2 |= this.writeTableCellElementContent(writer, file, (TableCellElement)oDFElement, bl);
        } else if (!(oDFElement instanceof TrackedChangesElement || oDFElement instanceof PageThumbnailElement || oDFElement instanceof ImageElement || oDFElement instanceof PageNumberElement)) {
            if (oDFElement instanceof DrawingObjectBaseElement) {
                bl2 = oDFElement instanceof ControlElement ? (bl2 |= this.writeControlElementContent(writer, (ControlElement)oDFElement)) : (oDFElement instanceof FrameElement ? (bl2 |= this.writeFrameElementContent(writer, file, (FrameElement)oDFElement, bl)) : (oDFElement instanceof ImageMapElement ? (bl2 |= this.writeImageMapElementContent(writer, file, (ImageMapElement)oDFElement, bl)) : (oDFElement instanceof TextBoxElement ? (bl2 |= this.writeTextBoxElementContent(writer, file, (TextBoxElement)oDFElement, bl)) : (oDFElement instanceof CustomShapeElement ? (bl2 |= this.writeCustomShapeElementContent(writer, file, (CustomShapeElement)oDFElement, bl)) : (oDFElement instanceof GElement ? (bl2 |= this.writeODFElementContent(writer, file, oDFElement, bl)) : (bl2 |= this.writeDrawingObjectBaseElementContent(writer, file, (DrawingObjectBaseElement)oDFElement, bl)))))));
            } else if (oDFElement instanceof PElement) {
                if (bl2 |= this.writeODFElementContent(writer, file, oDFElement, bl)) {
                    try {
                        writer.write(System.getProperty("line.separator"));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            } else {
                bl2 |= this.writeODFElementContent(writer, file, oDFElement, bl);
            }
        }
        return bl2;
    }
}

