/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssIf;
import com.google.gwt.resources.css.ast.CssMediaRule;
import com.google.gwt.resources.css.ast.CssModVisitor;
import com.google.gwt.resources.css.ast.CssNode;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.rg.CssResourceGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeRulesByContentVisitor
extends CssModVisitor {
    private Map<String, CssRule> rulesByContents = new HashMap<String, CssRule>();
    private final List<CssRule> rulesInOrder = new ArrayList<CssRule>();

    @Override
    public boolean visit(CssIf x, Context ctx) {
        this.visitInNewContext(x.getNodes());
        this.visitInNewContext(x.getElseNodes());
        return false;
    }

    @Override
    public boolean visit(CssMediaRule x, Context ctx) {
        this.visitInNewContext(x.getNodes());
        return false;
    }

    @Override
    public boolean visit(CssRule x, Context ctx) {
        StringBuilder b = new StringBuilder();
        for (CssProperty p : x.getProperties()) {
            b.append(p.getName()).append(":").append(p.getValues().getExpression());
            if (!p.isImportant()) continue;
            b.append("!important");
        }
        String content = b.toString();
        CssRule canonical = this.rulesByContents.get(content);
        if (canonical != null) {
            boolean hasCommon = false;
            int index = this.rulesInOrder.indexOf(canonical) + 1;
            assert (index != 0);
            ListIterator<CssRule> i = this.rulesInOrder.listIterator(index);
            while (i.hasNext() && !hasCommon) {
                hasCommon = CssResourceGenerator.haveCommonProperties((CssRule)i.next(), x);
            }
            if (!hasCommon) {
                canonical.getSelectors().addAll(x.getSelectors());
                ctx.removeMe();
                return false;
            }
        }
        this.rulesByContents.put(content, x);
        this.rulesInOrder.add(x);
        return false;
    }

    private void visitInNewContext(List<CssNode> nodes) {
        MergeRulesByContentVisitor v = new MergeRulesByContentVisitor();
        v.acceptWithInsertRemove(nodes);
        this.rulesInOrder.addAll(v.rulesInOrder);
    }
}

