/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import com.google.common.base.Objects;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.browser.ViatraQueryToolingBrowserPlugin;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.osgi.framework.Bundle;

@FinalFieldsConstructor
public class QueryRegistryTreeEntry {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final QueryRegistryTreePackage parent;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final IQuerySpecificationRegistryEntry entry;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private boolean isLoaded = false;

    public boolean load() {
        boolean _not;
        boolean _isLoaded = this.isLoaded();
        boolean bl = _not = !_isLoaded;
        if (_not) {
            try {
                boolean _notEquals;
                IQuerySpecification specification = (IQuerySpecification)this.entry.get();
                boolean bl2 = _notEquals = !Objects.equal((Object)specification, null);
                if (_notEquals) {
                    this.isLoaded = true;
                }
                return true;
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    String _fullyQualifiedName = this.entry.getFullyQualifiedName();
                    String _message = ex.getMessage();
                    String logMessage = String.format("Query Registry has encountered an error during loading of query %s: %s", _fullyQualifiedName, _message);
                    ViatraQueryToolingBrowserPlugin _default = ViatraQueryToolingBrowserPlugin.getDefault();
                    ILog _log = _default.getLog();
                    ViatraQueryGUIPlugin _default_1 = ViatraQueryGUIPlugin.getDefault();
                    Bundle _bundle = _default_1.getBundle();
                    String _symbolicName = _bundle.getSymbolicName();
                    Status _status = new Status(4, _symbolicName, logMessage, (Throwable)ex);
                    _log.log((IStatus)_status);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return false;
    }

    public String getSimpleName() {
        int _length;
        boolean _lessThan;
        String _xblockexpression = null;
        String fqn = this.entry.getFullyQualifiedName();
        int lastDotIndex = fqn.lastIndexOf(".");
        String _xifexpression = null;
        boolean _and = false;
        _and = lastDotIndex <= 0 ? false : (_lessThan = lastDotIndex < (_length = fqn.length()));
        if (!_and) {
            return fqn;
        }
        int _length_1 = fqn.length();
        _xifexpression = fqn.substring(lastDotIndex + 1, _length_1);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getPackageName() {
        int _length;
        boolean _lessThan;
        String _xblockexpression = null;
        String fqn = this.entry.getFullyQualifiedName();
        int lastDotIndex = fqn.lastIndexOf(".");
        String _xifexpression = null;
        boolean _and = false;
        _and = lastDotIndex <= 0 ? false : (_lessThan = lastDotIndex < (_length = fqn.length()));
        if (!_and) {
            return fqn;
        }
        int _lastIndexOf = fqn.lastIndexOf(".");
        _xifexpression = fqn.substring(0, _lastIndexOf);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Pure
    public QueryRegistryTreePackage getParent() {
        return this.parent;
    }

    @Pure
    public IQuerySpecificationRegistryEntry getEntry() {
        return this.entry;
    }

    @Pure
    public boolean isLoaded() {
        return this.isLoaded;
    }

    public QueryRegistryTreeEntry(QueryRegistryTreePackage parent, IQuerySpecificationRegistryEntry entry) {
        this.parent = parent;
        this.entry = entry;
    }
}

