/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.properties;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryHintOption;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class HintsPropertySource implements IPropertySource {
  private final QueryEvaluationHint hint;
  
  public HintsPropertySource(final QueryEvaluationHint hint) {
    this.hint = hint;
  }
  
  @Override
  public Object getEditableValue() {
    return this;
  }
  
  @Override
  public String toString() {
    Map<QueryHintOption, Object> _backendHintSettings = this.hint.getBackendHintSettings();
    boolean _isEmpty = _backendHintSettings.isEmpty();
    if (_isEmpty) {
      return "No hints specified";
    }
    return "";
  }
  
  @Override
  public IPropertyDescriptor[] getPropertyDescriptors() {
    final String category = "Hints";
    final List<IPropertyDescriptor> hints = Lists.<IPropertyDescriptor>newArrayList();
    Map<QueryHintOption, Object> _backendHintSettings = this.hint.getBackendHintSettings();
    Set<QueryHintOption> _keySet = _backendHintSettings.keySet();
    final Procedure1<QueryHintOption> _function = new Procedure1<QueryHintOption>() {
      @Override
      public void apply(final QueryHintOption option) {
        String _qualifiedName = option.getQualifiedName();
        final PropertyDescriptor property = new PropertyDescriptor(option, _qualifiedName);
        property.setCategory(category);
        hints.add(property);
      }
    };
    IterableExtensions.<QueryHintOption>forEach(_keySet, _function);
    IPropertyDescriptor[] _newArrayOfSize = new IPropertyDescriptor[0];
    return hints.<IPropertyDescriptor>toArray(_newArrayOfSize);
  }
  
  @Override
  public Object getPropertyValue(final Object id) {
    Map<QueryHintOption, Object> _backendHintSettings = this.hint.getBackendHintSettings();
    final Object hintValue = _backendHintSettings.get(id);
    return hintValue;
  }
  
  @Override
  public boolean isPropertySet(final Object id) {
    return false;
  }
  
  @Override
  public void resetPropertyValue(final Object id) {
  }
  
  @Override
  public void setPropertyValue(final Object id, final Object value) {
  }
}
