/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 * @since 1.4
 */
@SuppressWarnings("all")
public class RemoveQueryHandler extends AbstractHandler {
  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    ISelection _currentSelection = HandlerUtil.getCurrentSelection(event);
    final IStructuredSelection selection = ((IStructuredSelection) _currentSelection);
    Iterator _iterator = selection.iterator();
    Iterator<QueryResultTreeMatcher> _filter = Iterators.<QueryResultTreeMatcher>filter(_iterator, QueryResultTreeMatcher.class);
    final Procedure1<QueryResultTreeMatcher> _function = new Procedure1<QueryResultTreeMatcher>() {
      @Override
      public void apply(final QueryResultTreeMatcher matcher) {
        QueryResultTreeInput _parent = matcher.getParent();
        boolean _isReadOnlyEngine = _parent.isReadOnlyEngine();
        boolean _not = (!_isReadOnlyEngine);
        if (_not) {
          matcher.remove();
        }
      }
    };
    IteratorExtensions.<QueryResultTreeMatcher>forEach(_filter, _function);
    return null;
  }
}
