/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.module;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfCommonXAxisResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readonly.TmfXmlReadOnlyModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.w3c.dom.Element;

@NonNullByDefault
public class XmlXYDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfXYDataProvider {
    private static final String SPLIT_STRING = "/";
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("\\*");
    private final ITmfXmlStateAttribute fDisplay;
    private final XmlXYEntry fXmlEntry;

    private XmlXYDataProvider(ITmfTrace trace, XmlXYEntry entry, ITmfXmlStateAttribute display) {
        super(trace);
        this.fXmlEntry = entry;
        this.fDisplay = display;
    }

    public static @Nullable XmlXYDataProvider create(ITmfTrace trace, Set<String> analysisIds, Element entryElement) {
        ITmfStateSystem ss = XmlXYDataProvider.getStateSystemFromAnalyses(analysisIds, trace);
        if (ss == null) {
            return null;
        }
        ITmfXmlModelFactory fFactory = TmfXmlReadOnlyModelFactory.getInstance();
        String path = entryElement.getAttribute("path");
        if (path.isEmpty()) {
            path = "*";
        }
        XmlXYEntry entry = new XmlXYEntry(ss, path, entryElement);
        List<@NonNull Element> displayElements = TmfXmlUtils.getChildElements(entryElement, "display");
        if (displayElements.isEmpty()) {
            return null;
        }
        Element displayElement = displayElements.get(0);
        ITmfXmlStateAttribute display = fFactory.createStateAttribute(displayElement, entry);
        List<Element> seriesNameElements = TmfXmlUtils.getChildElements(entryElement, "name");
        ITmfXmlStateAttribute seriesName = null;
        if (!seriesNameElements.isEmpty()) {
            Element seriesNameElement = seriesNameElements.get(0);
            seriesName = fFactory.createStateAttribute(seriesNameElement, entry);
        }
        if (seriesName != null) {
            return new XmlXYDataProvider(trace, entry, display);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public TmfModelResponse<ITmfCommonXAxisModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        ITmfXmlStateAttribute display = this.fDisplay;
        XmlXYEntry entry = this.fXmlEntry;
        ITmfStateSystem ss = entry.getStateSystem();
        List<Integer> quarks = entry.getQuarks();
        HashMap<String, double[]> tempModel = new HashMap<String, double[]>();
        long[] xValues = filter.getTimesRequested();
        long currentEnd = ss.getCurrentEndTime();
        try {
            int i = 0;
            while (i < xValues.length) {
                long time = xValues[i];
                if (ss.getStartTime() <= time && time <= currentEnd) {
                    @NonNull List full = ss.queryFullState(time);
                    for (int quark : quarks) {
                        String seriesName = (String)((ITmfStateInterval)full.get(quark)).getValue();
                        if (seriesName == null || seriesName.isEmpty()) continue;
                        Object value = ((ITmfStateInterval)full.get(display.getAttributeQuark(quark, null))).getValue();
                        double[] yValues = (double[])tempModel.get(seriesName);
                        if (yValues != null) {
                            XmlXYDataProvider.setYValue(i, yValues, XmlXYDataProvider.extractValue(value), entry.getType());
                            continue;
                        }
                        yValues = new double[xValues.length];
                        XmlXYDataProvider.setYValue(i, yValues, XmlXYDataProvider.extractValue(value), entry.getType());
                        tempModel.put(seriesName, yValues);
                    }
                }
                ++i;
            }
        }
        catch (StateSystemDisposedException e) {
            return TmfCommonXAxisResponseFactory.createFailedResponse((String)e.getMessage());
        }
        ImmutableMap.Builder ySeries = ImmutableMap.builder();
        for (Map.Entry tempEntry : tempModel.entrySet()) {
            ySeries.put((Object)((String)tempEntry.getKey()), (Object)new YModel((String)tempEntry.getKey(), (double[])tempEntry.getValue()));
        }
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        return TmfCommonXAxisResponseFactory.create((String)Objects.requireNonNull(Messages.XmlDataProvider_DefaultXYTitle), (long[])xValues, (Map)ySeries.build(), (boolean)complete);
    }

    private static void setYValue(int index, double[] y, double value, DisplayType type) {
        if (type.equals((Object)DisplayType.DELTA)) {
            y[index] = value;
            double prevValue = value;
            if (index > 0) {
                prevValue = y[index - 1];
            }
            y[index] = value - prevValue;
        } else {
            y[index] = value;
        }
    }

    private static double extractValue(@Nullable Object val) {
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return 0.0;
    }

    private static @Nullable ITmfStateSystem getStateSystemFromAnalyses(Set<String> analysisIds, ITmfTrace trace) {
        LinkedList<ITmfAnalysisModuleWithStateSystems> stateSystemModules = new LinkedList<ITmfAnalysisModuleWithStateSystems>();
        if (analysisIds.isEmpty()) {
            for (ITmfAnalysisModuleWithStateSystems module : TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class)) {
                stateSystemModules.add(module);
            }
        } else {
            for (String moduleId : analysisIds) {
                ITmfAnalysisModuleWithStateSystems module = (ITmfAnalysisModuleWithStateSystems)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class, (String)moduleId);
                if (module == null) continue;
                stateSystemModules.add(module);
            }
        }
        for (ITmfAnalysisModuleWithStateSystems module : stateSystemModules) {
            module.schedule();
            if (!module.waitForInitialization()) continue;
            return (ITmfStateSystem)Iterables.getFirst((Iterable)module.getStateSystems(), null);
        }
        return null;
    }

    private static enum DisplayType {
        ABSOLUTE,
        DELTA;

    }

    private static class XmlXYEntry
    implements IXmlStateSystemContainer {
        private final ITmfStateSystem fStateSystem;
        private final String fPath;
        private final DisplayType fType;

        /*
         * Exception decompiling
         */
        public XmlXYEntry(ITmfStateSystem stateSystem, String path, Element entryElement) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl24 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl24 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public @Nullable String getAttributeValue(@Nullable String name) {
            return name;
        }

        @Override
        public ITmfStateSystem getStateSystem() {
            return this.fStateSystem;
        }

        @Override
        public @NonNull Iterable<@NonNull TmfXmlLocation> getLocations() {
            return Collections.emptySet();
        }

        public DisplayType getType() {
            return this.fType;
        }

        public List<Integer> getQuarks() {
            String[] paths = this.fPath.split(XmlXYDataProvider.SPLIT_STRING);
            List<Integer> quarks = Collections.singletonList(-1);
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                LinkedList<Integer> subQuarks = new LinkedList<Integer>();
                String name = WILDCARD_PATTERN.matcher(path).replaceAll(".*");
                for (int relativeQuark : quarks) {
                    subQuarks.addAll(this.fStateSystem.getSubAttributes(relativeQuark, false, name));
                }
                quarks = subQuarks;
                ++n2;
            }
            return quarks;
        }
    }
}

