/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlBasicTransition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.w3c.dom.Element;

public class TmfXmlStateTransition
extends TmfXmlBasicTransition {
    private static final String SAVED_STORED_FIELDS_ACTION_STRING = "#saveStoredFields";
    private static final String CLEAR_STORED_FIELDS_ACTION_STRINGS = "#clearStoredFields";
    private final String fTarget;
    private final List<String> fAction;
    private final boolean fStoredFieldsToBeSaved;
    private final boolean fStoredFieldsToBeCleared;

    public TmfXmlStateTransition(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container) {
        super(node);
        String target = node.getAttribute("target");
        if (target.isEmpty()) {
            throw new IllegalStateException("No target state has been specified.");
        }
        this.fTarget = target;
        String action = node.getAttribute("action");
        List<String> actions = action.equals("") ? Collections.EMPTY_LIST : Arrays.asList(action.split(":"));
        this.fStoredFieldsToBeSaved = node.getAttribute("saveStoredFields").equals("") ? false : Boolean.parseBoolean(node.getAttribute("saveStoredFields"));
        this.fStoredFieldsToBeCleared = node.getAttribute("clearStoredFields").equals("") ? false : Boolean.parseBoolean(node.getAttribute("clearStoredFields"));
        this.fAction = new ArrayList<String>();
        if (this.fStoredFieldsToBeSaved) {
            this.fAction.add(SAVED_STORED_FIELDS_ACTION_STRING);
        }
        this.fAction.addAll(actions);
        if (this.fStoredFieldsToBeCleared) {
            this.fAction.add(CLEAR_STORED_FIELDS_ACTION_STRINGS);
        }
    }

    public String getTarget() {
        return this.fTarget;
    }

    public List<String> getAction() {
        return this.fAction;
    }

    public boolean isStoredFieldsToBeSaved() {
        return this.fStoredFieldsToBeSaved;
    }

    public boolean isStoredFieldsToBeCleared() {
        return this.fStoredFieldsToBeCleared;
    }
}

