/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote.management;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.eclipse.team.svn.core.operation.remote.management.AddRevisionLinkOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRevisionLink;
import org.eclipse.team.svn.core.resource.IRevisionLinkProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.eclipse.team.svn.ui.panel.common.InputRevisionPanel;
import org.eclipse.team.svn.ui.repository.model.RepositoryRevision;

public class EditRevisionLinkAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        RepositoryRevision revision = ((RepositoryRevision[])this.getAdaptedSelection(RepositoryRevision.class))[0];
        final IRevisionLink oldLink = revision.getRevisionLink();
        IRepositoryResource resource = oldLink.getRepositoryResource();
        SVNRevision oldRevision = revision.getRevision();
        InputRevisionPanel panel = new InputRevisionPanel(oldLink.getRepositoryResource(), true, oldLink.getComment());
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            SVNRevision selectedRevision = panel.getSelectedRevision();
            final String comment = panel.getRevisionComment();
            CompositeOperation op = new CompositeOperation("Operation_EditRevisionLink", SVNUIMessages.class);
            if (!oldRevision.equals((Object)selectedRevision)) {
                AbstractActionOperation mainOp = new AbstractActionOperation("Operation_EditRevisionLink", SVNUIMessages.class){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        oldLink.getRepositoryResource().getRepositoryLocation().removeRevisionLink(oldLink);
                    }
                };
                resource = SVNUtility.copyOf((IRepositoryResource)resource);
                resource.setSelectedRevision(selectedRevision);
                final LocateResourceURLInHistoryOperation locateOp = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{resource});
                AddRevisionLinkOperation addOp = new AddRevisionLinkOperation(new IRevisionLinkProvider(){

                    public IRevisionLink[] getRevisionLinks() {
                        IRepositoryResource[] resources = locateOp.getRepositoryResources();
                        IRevisionLink[] links = new IRevisionLink[resources.length];
                        int i = 0;
                        while (i < resources.length) {
                            links[i] = SVNUtility.createRevisionLink((IRepositoryResource)resources[i]);
                            links[i].setComment(comment);
                            ++i;
                        }
                        return links;
                    }
                }, selectedRevision);
                op.add((IActionOperation)mainOp);
                op.add((IActionOperation)locateOp, new IActionOperation[]{mainOp});
                op.add((IActionOperation)addOp, new IActionOperation[]{mainOp, locateOp});
            } else {
                AbstractActionOperation mainOp = new AbstractActionOperation("Operation_EditRevisionLink", SVNUIMessages.class){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        oldLink.setComment(comment);
                    }
                };
                op.add((IActionOperation)mainOp);
            }
            op.add((IActionOperation)new SaveRepositoryLocationsOperation());
            op.add((IActionOperation)new RefreshRepositoryLocationsOperation(new IRepositoryLocation[]{resource.getRepositoryLocation()}, true));
            this.runScheduled((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        return this.getAdaptedSelection(RepositoryRevision.class).length == 1;
    }
}

