/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.services;

import java.net.ConnectException;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.concurrent.Rendezvous;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFChannelException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.BlockingFileSystemProxy;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class Operation {
    public static final long DEFAULT_TIMEOUT = 60000L;

    private Operation() {
    }

    public static IChannel openChannel(final IPeer peer) throws TCFChannelException {
        final TCFChannelException[] errors = new TCFChannelException[1];
        final IChannel[] channels = new IChannel[1];
        final Rendezvous rendezvous = new Rendezvous();
        Tcf.getChannelManager().openChannel(peer, null, new IChannelManager.DoneOpenChannel(){

            public void doneOpenChannel(Throwable error, IChannel channel) {
                if (error != null) {
                    if (error instanceof ConnectException) {
                        String message = NLS.bind((String)Messages.Operation_NotResponding, (Object)peer.getID());
                        errors[0] = new TCFChannelException(4, message);
                    } else if (!(error instanceof OperationCanceledException)) {
                        String message = NLS.bind((String)Messages.Operation_OpeningChannelFailureMessage, (Object)peer.getID(), (Object)error.getMessage());
                        errors[0] = new TCFChannelException(0, message, error);
                    }
                } else {
                    channels[0] = channel;
                }
                rendezvous.arrive();
            }
        });
        try {
            rendezvous.waiting(60000L);
        }
        catch (TimeoutException timeoutException) {
            throw new TCFChannelException(4, Messages.Operation_TimeoutOpeningChannel);
        }
        if (errors[0] != null) {
            throw errors[0];
        }
        return channels[0];
    }

    public static IFileSystem getBlockingFileSystem(final IChannel channel) {
        if (Protocol.isDispatchThread()) {
            IFileSystem service = (IFileSystem)channel.getRemoteService(IFileSystem.class);
            return new BlockingFileSystemProxy(service);
        }
        final IFileSystem[] service = new IFileSystem[1];
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                service[0] = Operation.getBlockingFileSystem(channel);
            }
        });
        return service[0];
    }
}

