/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.componentization.ViewpointResourceHandler;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class CompositeViewpointResourceHandler
implements ViewpointResourceHandler {
    private final List<ViewpointResourceHandler> handlers = Lists.newArrayList();

    public synchronized void addResourceType(ViewpointResourceHandler handler) {
        if (!this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    public synchronized void removeResourceType(ViewpointResourceHandler handler) {
        this.handlers.remove(handler);
    }

    @Override
    public synchronized boolean handles(final URI uri) {
        return Iterables.any(this.handlers, (Predicate)new Predicate<ViewpointResourceHandler>(){

            public boolean apply(ViewpointResourceHandler handler) {
                return handler.handles(uri);
            }
        });
    }

    @Override
    public synchronized Set<Viewpoint> collectViewpointDefinitions(Resource res) {
        URI uri = res.getURI();
        for (ViewpointResourceHandler handler : this.handlers) {
            if (!handler.handles(uri)) continue;
            return handler.collectViewpointDefinitions(res);
        }
        return Collections.emptySet();
    }
}

