/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.ConnectionEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionService;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.def.DiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.def.ToolPaletteImageDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramDirectEditPartEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeAddEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeDeleteEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeMoveEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePostAddEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePreDeleteEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.NodeTemplateVisibilityEvent;
import org.eclipse.sapphire.ui.diagram.state.DiagramEditorPageState;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributorPart;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.util.ListFactory;

public final class SapphireDiagramEditorPagePart
extends SapphireEditorPagePart {
    private Element modelElement;
    private DiagramEditorPageDef diagramPageDef = null;
    private List<IDiagramNodeDef> nodeDefs;
    private List<IDiagramConnectionDef> connectionDefs;
    private List<DiagramNodeTemplate> nodeTemplates;
    private NodeTemplateListener nodeTemplateListener;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private List<ISapphirePart> selections;
    private boolean showGrid;
    private boolean showGuides;
    private int gridUnit;
    private int verticalGridUnit;
    private List<List<FunctionResult>> connectionImageDataFunctionResults;
    private Point mouseLocation;

    @Override
    protected void init() {
        this.diagramPageDef = (DiagramEditorPageDef)this.definition;
        ImpliedElementProperty modelElementProperty = (ImpliedElementProperty)this.resolve((String)this.diagramPageDef.getProperty().content());
        this.modelElement = modelElementProperty != null ? this.getModelElement().property((ElementProperty)modelElementProperty).content() : this.getModelElement();
        super.init();
        this.showGrid = (Boolean)this.diagramPageDef.getGridDefinition().isVisible().content();
        this.showGuides = (Boolean)this.diagramPageDef.getGuidesDefinition().isVisible().content();
        this.gridUnit = (Integer)this.diagramPageDef.getGridDefinition().getGridUnit().content();
        this.verticalGridUnit = (Integer)this.diagramPageDef.getGridDefinition().getVerticalGridUnit().content();
        this.mouseLocation = new Point(0, 0);
        this.nodeTemplateListener = new NodeTemplateListener();
        this.nodeTemplates = new ArrayList<DiagramNodeTemplate>();
        this.nodeDefs = this.diagramPageDef.getDiagramNodeDefs();
        this.connectionDefs = this.diagramPageDef.getDiagramConnectionDefs();
        for (IDiagramNodeDef nodeDef : this.nodeDefs) {
            DiagramNodeTemplate nodeTemplate = new DiagramNodeTemplate();
            nodeTemplate.init(this, this.modelElement, nodeDef, Collections.emptyMap());
            nodeTemplate.initialize();
            this.nodeTemplates.add(nodeTemplate);
            nodeTemplate.addTemplateListener(this.nodeTemplateListener);
            nodeTemplate.attach((Listener)new FilteredListener<PartVisibilityEvent>(){

                protected void handleTypedEvent(PartVisibilityEvent event) {
                    SapphireDiagramEditorPagePart.this.handleNodeTemplateVisibilityChange((DiagramNodeTemplate)event.part());
                }
            });
        }
        this.connectionImageDataFunctionResults = new ArrayList<List<FunctionResult>>();
        for (IDiagramConnectionDef connectionDef : this.connectionDefs) {
            ElementList<ToolPaletteImageDef> imageDefs = connectionDef.getToolPaletteImages();
            ArrayList<FunctionResult> frs = new ArrayList<FunctionResult>();
            for (ToolPaletteImageDef imageDef : imageDefs) {
                FunctionResult imageResult = this.initExpression((Function)imageDef.getToolPaletteImage().content(), ImageData.class, null, new Runnable(){

                    @Override
                    public void run() {
                        SapphireDiagramEditorPagePart.this.broadcast(new SapphirePart.ImageChangedEvent(SapphireDiagramEditorPagePart.this));
                    }
                });
                frs.add(imageResult);
            }
            this.connectionImageDataFunctionResults.add(frs);
        }
        this.selections = new ArrayList<ISapphirePart>();
        this.selections.add(this);
        this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.modelElement);
        this.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphireEditorPagePart.SelectionChangedEvent) {
                    SapphireDiagramEditorPagePart.this.refreshPropertiesViewContribution();
                }
            }
        });
        this.refreshPropertiesViewContribution();
        this.service(ConnectionService.class).attach((Listener)new FilteredListener<ConnectionEvent>(){

            protected void handleTypedEvent(ConnectionEvent event) {
                SapphireDiagramEditorPagePart.this.broadcast(event);
            }
        });
    }

    @Override
    public Element getLocalModelElement() {
        return this.modelElement;
    }

    public boolean isGridVisible() {
        return this.showGrid;
    }

    public void setGridVisible(boolean visible) {
        if (visible != this.showGrid) {
            this.showGrid = visible;
            this.notifyGridStateChange();
        }
    }

    public boolean isShowGuides() {
        return this.showGuides;
    }

    public void setShowGuides(boolean showGuides) {
        if (this.showGuides != showGuides) {
            this.showGuides = showGuides;
            this.notifyGuideStateChange();
        }
    }

    public int getMinZoomLevel() {
        return 50;
    }

    public int getMaxZoomLevel() {
        return 400;
    }

    public int getZoomLevel() {
        return (Integer)this.state().getZoomLevel().content();
    }

    public void setZoomLevel(int level) {
        int currentZoomLevel = (Integer)this.state().getZoomLevel().content();
        if (currentZoomLevel != level) {
            int newZoomLevel = level;
            int min = this.getMinZoomLevel();
            if (level < min) {
                newZoomLevel = min;
            } else {
                int max = this.getMaxZoomLevel();
                if (level > max) {
                    newZoomLevel = max;
                }
            }
            if (currentZoomLevel != newZoomLevel) {
                this.state().setZoomLevel(newZoomLevel);
                this.broadcast(new ZoomLevelEvent(this, currentZoomLevel, newZoomLevel));
            }
        }
    }

    public void autoLayout(boolean horizontal) {
        this.broadcast(new PreAutoLayoutEvent(this));
        this.broadcast(new AutoLayoutEvent(this, horizontal));
        this.broadcast(new PostAutoLayoutEvent(this));
    }

    @Override
    public final DiagramEditorPageState state() {
        return (DiagramEditorPageState)super.state();
    }

    public int getGridUnit() {
        return this.gridUnit;
    }

    public int getVerticalGridUnit() {
        if (this.verticalGridUnit > 0) {
            return this.verticalGridUnit;
        }
        return this.gridUnit;
    }

    public Point getMouseLocation() {
        return this.mouseLocation;
    }

    public void setMouseLocation(int x, int y) {
        this.mouseLocation.setX(x);
        this.mouseLocation.setY(y);
    }

    public void selectAndDirectEdit(ISapphirePart part) {
        this.notifyDirectEdit(part);
    }

    public void saveDiagram() {
        this.notifyDiagramSave();
    }

    public DiagramEditorPageDef getPageDef() {
        return this.diagramPageDef;
    }

    public List<DiagramNodeTemplate> getNodeTemplates() {
        return this.nodeTemplates;
    }

    public List<DiagramNodeTemplate> getVisibleNodeTemplates() {
        ArrayList<DiagramNodeTemplate> visibleNodeTemplates = new ArrayList<DiagramNodeTemplate>();
        for (DiagramNodeTemplate nodeTemplate : this.getNodeTemplates()) {
            if (!nodeTemplate.visible()) continue;
            visibleNodeTemplates.add(nodeTemplate);
        }
        return visibleNodeTemplates;
    }

    public List<ConnectionPalette> getConnectionPalettes() {
        ArrayList<ConnectionPalette> list = new ArrayList<ConnectionPalette>();
        int i = 0;
        while (i < this.connectionImageDataFunctionResults.size()) {
            List<FunctionResult> results = this.connectionImageDataFunctionResults.get(i);
            ArrayList<ImageData> imageDatas = new ArrayList<ImageData>();
            for (FunctionResult result : results) {
                ImageData imageData = (ImageData)result.value();
                imageDatas.add(imageData);
            }
            IDiagramConnectionDef def = this.connectionDefs.get(i);
            ConnectionPalette palette = new ConnectionPalette(imageDatas, def);
            list.add(palette);
            ++i;
        }
        return list;
    }

    public IDiagramConnectionDef getDiagramConnectionDef(String connId) {
        if (connId == null) {
            throw new IllegalArgumentException();
        }
        IDiagramConnectionDef connDef = null;
        for (IDiagramConnectionDef def : this.connectionDefs) {
            String id = (String)def.getId().content();
            if (id == null || !id.equalsIgnoreCase(connId)) continue;
            connDef = def;
            break;
        }
        return connDef;
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> contextSet = new HashSet<String>();
        contextSet.add("Sapphire.Diagram");
        contextSet.add("Sapphire.Diagram.Editor");
        contextSet.add("Sapphire.Diagram.MultipleParts");
        contextSet.add("Sapphire.Diagram.Header");
        return contextSet;
    }

    @Override
    public String getMainActionContext() {
        return "Sapphire.Diagram.Editor";
    }

    public List<ISapphirePart> getSelections() {
        return this.selections;
    }

    public void setSelections(List<ISapphirePart> selections, boolean force) {
        boolean selectionChanged = false;
        if (this.selections.size() != selections.size()) {
            selectionChanged = true;
        } else if (!this.selections.containsAll(selections) || !selections.containsAll(this.selections)) {
            selectionChanged = true;
        }
        if (selectionChanged || force) {
            this.selections.clear();
            this.selections.addAll(selections);
            this.broadcast(new SapphireEditorPagePart.SelectionChangedEvent(this));
        }
    }

    public void selectAll() {
        this.notifySelectAll();
    }

    public void selectAllNodes() {
        this.notifySelectAllNodes();
    }

    private void refreshPropertiesViewContribution() {
        List<ISapphirePart> selections = this.getSelections();
        SapphirePart propertiesViewContribution = null;
        if (selections.size() == 1) {
            ISapphirePart selection = selections.get(0);
            if (selection == this) {
                propertiesViewContribution = this.propertiesViewContributionManager.getPropertiesViewContribution();
            } else if (selection instanceof PropertiesViewContributorPart) {
                propertiesViewContribution = ((PropertiesViewContributorPart)((Object)selection)).getPropertiesViewContribution();
            }
        }
        if (propertiesViewContribution == null || !propertiesViewContribution.getLocalModelElement().disposed()) {
            this.setPropertiesViewContribution((PropertiesViewContributionPart)propertiesViewContribution);
        }
    }

    private void handleNodeTemplateVisibilityChange(DiagramNodeTemplate nodeTemplate) {
        if (nodeTemplate.visible()) {
            nodeTemplate.showAllNodeParts();
            this.notifyNodeTemplateVisibilityChange(nodeTemplate);
        } else {
            this.notifyNodeTemplateVisibilityChange(nodeTemplate);
            nodeTemplate.hideAllNodeParts();
        }
        this.notifyDiagramChange();
        this.refreshPropertiesViewContribution();
    }

    public List<DiagramNodePart> getNodes() {
        ListFactory nodes = ListFactory.start();
        for (DiagramNodeTemplate template : this.getNodeTemplates()) {
            nodes.add(template.getDiagramNodes());
        }
        return nodes.result();
    }

    public List<DiagramConnectionPart> getConnections() {
        return this.service(ConnectionService.class).list();
    }

    public List<IDiagramConnectionDef> possibleConnectionDefs(DiagramNodePart nodePart) {
        return this.service(ConnectionService.class).possibleConnectionDefs(nodePart);
    }

    public DiagramNodePart getDiagramNodePart(Element nodeElement) {
        if (nodeElement == null) {
            return null;
        }
        List<DiagramNodeTemplate> nodeTemplates = this.getNodeTemplates();
        for (DiagramNodeTemplate nodeTemplate : nodeTemplates) {
            List<DiagramNodePart> nodeParts = nodeTemplate.getDiagramNodes();
            for (DiagramNodePart nodePart : nodeParts) {
                if (nodePart.getLocalModelElement() != nodeElement) continue;
                return nodePart;
            }
        }
        return null;
    }

    public DiagramNodePart getNode(String nodeId) {
        if (nodeId != null) {
            List<DiagramNodePart> nodes = this.getNodes();
            for (DiagramNodePart node : nodes) {
                if (node.getId() == null || !node.getId().equals(nodeId)) continue;
                return node;
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.connectionImageDataFunctionResults.size()) {
            List<FunctionResult> results = this.connectionImageDataFunctionResults.get(i);
            for (FunctionResult result : results) {
                if (result == null) continue;
                result.dispose();
            }
            ++i;
        }
        this.disposeParts();
    }

    private void disposeParts() {
        for (DiagramNodeTemplate nodeTemplate : this.nodeTemplates) {
            nodeTemplate.dispose();
        }
        this.nodeTemplates.clear();
    }

    public List<DiagramNodeTemplate> getNodeTemplates(PropertyDef modelProperty) {
        ArrayList<DiagramNodeTemplate> nodeTemplates = new ArrayList<DiagramNodeTemplate>();
        for (DiagramNodeTemplate nodeTemplate : this.nodeTemplates) {
            if (nodeTemplate.getModelProperty() != modelProperty) continue;
            nodeTemplates.add(nodeTemplate);
        }
        return nodeTemplates;
    }

    public DiagramNodeTemplate getNodeTemplate(String nodeType) {
        for (DiagramNodeTemplate nodeTemplate : this.nodeTemplates) {
            if (!nodeTemplate.getNodeTypeId().equalsIgnoreCase(nodeType)) continue;
            return nodeTemplate;
        }
        return null;
    }

    private void notifyNodeAdd(DiagramNodePart nodePart) {
        DiagramNodeAddEvent event = new DiagramNodeAddEvent(nodePart);
        this.broadcast(event);
    }

    private void notifyNodeDelete(DiagramNodePart nodePart) {
        DiagramNodeDeleteEvent event = new DiagramNodeDeleteEvent(nodePart);
        this.broadcast(event);
    }

    private void notifyNodeAboutToBeDeleted(DiagramNodePart nodePart) {
        DiagramNodePreDeleteEvent event = new DiagramNodePreDeleteEvent(nodePart);
        this.broadcast(event);
    }

    private void notifyNodeAdded(DiagramNodePart nodePart) {
        DiagramNodePostAddEvent event = new DiagramNodePostAddEvent(nodePart);
        this.broadcast(event);
    }

    private void notifyNodeTemplateVisibilityChange(DiagramNodeTemplate nodeTemplate) {
        NodeTemplateVisibilityEvent event = new NodeTemplateVisibilityEvent(nodeTemplate);
        this.broadcast(event);
    }

    private void notifyNodeMove(DiagramNodeMoveEvent event) {
        this.broadcast(event);
    }

    private void notifyDirectEdit(ISapphirePart part) {
        DiagramDirectEditPartEvent event = new DiagramDirectEditPartEvent(part);
        this.broadcast(event);
    }

    private void notifyGridStateChange() {
        DiagramPageEvent event = new DiagramPageEvent(this);
        event.setDiagramPageEventType(DiagramPageEvent.DiagramPageEventType.GridStateChange);
        this.broadcast(event);
    }

    private void notifyGuideStateChange() {
        DiagramPageEvent event = new DiagramPageEvent(this);
        event.setDiagramPageEventType(DiagramPageEvent.DiagramPageEventType.GuideStateChange);
        this.broadcast(event);
    }

    private void notifyDiagramChange() {
        DiagramPageEvent event = new DiagramPageEvent(this);
        event.setDiagramPageEventType(DiagramPageEvent.DiagramPageEventType.DiagramChange);
        this.broadcast(event);
    }

    private void notifyDiagramSave() {
        DiagramPageEvent event = new DiagramPageEvent(this);
        event.setDiagramPageEventType(DiagramPageEvent.DiagramPageEventType.DiagramSave);
        this.broadcast(event);
    }

    private void notifySelectAll() {
        DiagramPageEvent event = new DiagramPageEvent(this);
        event.setDiagramPageEventType(DiagramPageEvent.DiagramPageEventType.SelectAll);
        this.broadcast(event);
    }

    private void notifySelectAllNodes() {
        DiagramPageEvent event = new DiagramPageEvent(this);
        event.setDiagramPageEventType(DiagramPageEvent.DiagramPageEventType.SelectAllNodes);
        this.broadcast(event);
    }

    public static final class AutoLayoutEvent
    extends SapphirePart.PartEvent {
        private boolean horizontal;

        public AutoLayoutEvent(SapphirePart part, boolean horizontal) {
            super(part);
            this.horizontal = horizontal;
        }

        public boolean horizontal() {
            return this.horizontal;
        }
    }

    public static final class ConnectionPalette {
        private IDiagramConnectionDef connectionDef;
        private ImageData smallImage;
        private ImageData largeImage;

        public ConnectionPalette(List<ImageData> imageDatas, IDiagramConnectionDef connectionDef) {
            this.connectionDef = connectionDef;
            if (imageDatas.size() == 1) {
                this.smallImage = this.largeImage = imageDatas.get(0);
            } else if (imageDatas.size() == 2) {
                ArrayList<ImageDescriptor> imageDescriptors = new ArrayList<ImageDescriptor>();
                for (ImageData imageData : imageDatas) {
                    imageDescriptors.add(SwtUtil.toImageDescriptor(imageData));
                }
                org.eclipse.swt.graphics.ImageData id1 = ((ImageDescriptor)imageDescriptors.get(0)).getImageData();
                org.eclipse.swt.graphics.ImageData id2 = ((ImageDescriptor)imageDescriptors.get(1)).getImageData();
                if (id1.width > id2.width || id1.height > id2.height) {
                    this.smallImage = imageDatas.get(1);
                    this.largeImage = imageDatas.get(0);
                } else {
                    this.smallImage = imageDatas.get(0);
                    this.largeImage = imageDatas.get(1);
                }
            }
        }

        public ImageData getSmallIcon() {
            return this.smallImage;
        }

        public ImageData getLargeIcon() {
            return this.largeImage;
        }

        public IDiagramConnectionDef getConnectionDef() {
            return this.connectionDef;
        }
    }

    private class NodeTemplateListener
    extends DiagramNodeTemplate.DiagramNodeTemplateListener {
        private NodeTemplateListener() {
        }

        @Override
        public void handleNodeAdd(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeAdd(nodePart);
        }

        @Override
        public void handlePostNodeAdd(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeAdded(nodePart);
        }

        @Override
        public void handleNodeDelete(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeDelete(nodePart);
        }

        @Override
        public void handlePreNodeDelete(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeAboutToBeDeleted(nodePart);
        }

        @Override
        public void handleNodeMove(DiagramNodeMoveEvent event) {
            SapphireDiagramEditorPagePart.this.notifyNodeMove(event);
        }
    }

    public static final class PostAutoLayoutEvent
    extends SapphirePart.PartEvent {
        public PostAutoLayoutEvent(SapphirePart part) {
            super(part);
        }
    }

    public static final class PreAutoLayoutEvent
    extends SapphirePart.PartEvent {
        public PreAutoLayoutEvent(SapphirePart part) {
            super(part);
        }
    }

    public static final class ZoomLevelEvent
    extends SapphirePart.PartEvent {
        private final int before;
        private final int after;

        public ZoomLevelEvent(SapphirePart part, int before, int after) {
            super(part);
            this.before = before;
            this.after = after;
        }

        public int before() {
            return this.before;
        }

        public int after() {
            return this.after;
        }
    }
}

