/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.ValidationMarkerPart;
import org.eclipse.sapphire.ui.diagram.shape.def.ValidationMarkerSize;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.figures.SmoothImageFigure;
import org.eclipse.sapphire.ui.swt.gef.model.ValidationMarkerModel;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeEditPart;
import org.eclipse.swt.graphics.Image;

public class ValidationMarkerEditPart
extends ShapeEditPart {
    private static final ImageDescriptor IMG_ERROR_SMALL = SwtUtil.createImageDescriptor(ValidationMarkerEditPart.class, (String)"error_small.png");
    private static final ImageDescriptor IMG_ERROR = SwtUtil.createImageDescriptor(ValidationMarkerEditPart.class, (String)"error.gif");
    private static final ImageDescriptor IMG_WARNING_SMALL = SwtUtil.createImageDescriptor(ValidationMarkerEditPart.class, (String)"warning_small.png");
    private static final ImageDescriptor IMG_WARNING = SwtUtil.createImageDescriptor(ValidationMarkerEditPart.class, (String)"warning.gif");

    public ValidationMarkerEditPart(DiagramConfigurationManager configManager) {
        super(configManager);
    }

    @Override
    protected IFigure createFigure() {
        ValidationMarkerModel markerModel = (ValidationMarkerModel)this.getModel();
        ValidationMarkerPart markerPart = (ValidationMarkerPart)markerModel.getSapphirePart();
        DiagramNodePart nodePart = (DiagramNodePart)markerPart.nearest(DiagramNodePart.class);
        ValidationMarkerSize size = markerPart.getSize();
        Image image = null;
        Element model = nodePart.getModelElement();
        Status status = model.validation();
        if (status.severity() != Status.Severity.OK) {
            if (status.severity() == Status.Severity.WARNING) {
                image = size == ValidationMarkerSize.SMALL ? nodePart.getSwtResourceCache().image(IMG_WARNING_SMALL) : nodePart.getSwtResourceCache().image(IMG_WARNING);
            } else if (status.severity() == Status.Severity.ERROR) {
                image = size == ValidationMarkerSize.SMALL ? nodePart.getSwtResourceCache().image(IMG_ERROR_SMALL) : nodePart.getSwtResourceCache().image(IMG_ERROR);
            }
        }
        if (image != null) {
            SmoothImageFigure markerFigure = new SmoothImageFigure(image);
            return markerFigure;
        }
        return null;
    }
}

