/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core.commands;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.remote.internal.proxy.core.ProxyConnection;
import org.eclipse.remote.internal.proxy.core.commands.AbstractCommand;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class GetCwdCommand
extends AbstractCommand<String> {
    private final DataOutputStream out;
    private final DataInputStream in;

    public GetCwdCommand(ProxyConnection conn) {
        super(conn);
        this.out = new DataOutputStream(conn.getCommandChannel().getOutputStream());
        this.in = new DataInputStream(conn.getCommandChannel().getInputStream());
    }

    @Override
    public String call() throws ProxyException {
        try {
            StreamChannel chan = this.openChannel();
            DataInputStream resultStream = new DataInputStream(chan.getInputStream());
            this.out.writeByte(1);
            this.out.writeShort(103);
            this.out.writeByte(chan.getId());
            this.out.flush();
            byte res = this.in.readByte();
            if (res != 0) {
                String errMsg = this.in.readUTF();
                System.err.println("getcwd command failed:" + errMsg);
                throw new ProxyException(errMsg);
            }
            String cwd = resultStream.readUTF();
            chan.close();
            return cwd;
        }
        catch (IOException e) {
            throw new ProxyException(e.getMessage());
        }
    }
}

