/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeUnion;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValue;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueUnion;
import org.eclipse.ptp.debug.core.pdi.model.aif.IValueParent;
import org.eclipse.ptp.internal.debug.core.pdi.aif.ValueParent;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class AIFValueUnion
extends ValueParent
implements IAIFValueUnion {
    private final Map<String, IAIFValue> values = new HashMap<String, IAIFValue>();

    public AIFValueUnion(IValueParent parent, IAIFTypeUnion type, AIFFactory.SimpleByteBuffer buffer) {
        super(parent, type);
        this.parse(buffer);
    }

    @Override
    public IAIFValue getFieldValue(String name) {
        return this.values.get(name);
    }

    @Override
    public String getValueString() throws AIFException {
        String content = "(";
        int length = this.values.size();
        int i = 0;
        while (i < length) {
            IAIFValue value = this.values.get(i);
            content = String.valueOf(content) + value.getValueString();
            if (i < length - 1) {
                content = String.valueOf(content) + ",";
            }
            ++i;
        }
        return String.valueOf(content) + ")";
    }

    @Override
    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        IAIFTypeUnion typeUnion = (IAIFTypeUnion)this.getType();
        String[] names = typeUnion.getFieldNames();
        IAIFType[] types = typeUnion.getFieldTypes();
        int i = 0;
        while (i < names.length) {
            IAIFValue val = AIFFactory.getAIFValue(this.getParent(), types[i], buffer);
            this.values.put(names[i], val);
            this.setSize(this.sizeof() + val.sizeof());
            ++i;
        }
    }
}

