/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Bindings;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.FunctionName;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.MethodBinding;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.MethodStub;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.ReturnStatement;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.ast.rewrite.ListRewrite;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.php.internal.core.ast.scanner.php5.PHPAstLexer;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.context.FileContext;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;
import org.eclipse.php.internal.core.typeinference.goals.ClassVariableDeclarationGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.CodeGenerationSettings;
import org.eclipse.php.internal.ui.corext.codemanipulation.StubUtility;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.CodeGeneration;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class CodeGenerationUtils {
    private CodeGenerationUtils() {
    }

    public static IMethod findMethod(String name, int parameters, boolean isConstructor, IType type) throws ModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (CodeGenerationUtils.isSameMethodSignature(name, parameters, isConstructor, method)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isSameMethodSignature(String name, int parameters, boolean isConstructor, IMethod curr) throws ModelException {
        String[] currParamTypes;
        return (isConstructor || name.equals(curr.getElementName())) && isConstructor == curr.isConstructor() && parameters == (currParamTypes = curr.getParameterNames()).length;
    }

    public static IMethod getSetter(IField field) throws ModelException {
        return CodeGenerationUtils.findMethod(CodeGenerationUtils.getSetterName(field), 1, false, field.getDeclaringType());
    }

    public static String getSetterName(IField field) throws ModelException {
        return "set" + CodeGenerationUtils.toInitialCaps(field.getElementName(), true);
    }

    private static String toInitialCaps(String label, boolean toUpper) {
        String s = label;
        if (s == null || s.length() == 0) {
            return "";
        }
        if ((s = s.substring(1)).charAt(0) == '_' && s.length() > 1 && s.charAt(1) != '_') {
            s = s.substring(1);
        }
        StringBuilder res = new StringBuilder();
        if (toUpper) {
            res.append(Character.toUpperCase(s.charAt(0)));
        } else {
            res.append(Character.toLowerCase(s.charAt(0)));
        }
        if (s.length() > 1) {
            res.append(s.substring(1));
        }
        return res.toString();
    }

    public static IMethod getGetter(IField field) throws ModelException {
        String getterName = CodeGenerationUtils.getGetterName(field);
        return CodeGenerationUtils.findMethod(getterName, 0, false, field.getDeclaringType());
    }

    public static String getGetterName(IField field) {
        String prefix = "get";
        try {
            IEvaluatedType type = PHPSimpleTypes.fromString((String)field.getType());
            if (type != null && type.equals(PHPSimpleTypes.BOOLEAN)) {
                prefix = "is";
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return String.valueOf(prefix) + CodeGenerationUtils.toInitialCaps(field.getElementName(), true);
    }

    public static void createSetterStub(IField field, String setterName, boolean addComments, int flags, ListRewrite rewrite, ASTNode insertion) throws CoreException {
        String fieldName = field.getElementName();
        IType parentType = field.getDeclaringType();
        AST ast = rewrite.getASTRewrite().getAST();
        String lineDelim = StubUtility.getLineDelimiterUsed(field.getScriptProject());
        MethodDeclarationStub method = new MethodDeclarationStub(ast);
        FunctionDeclaration func = ast.newFunctionDeclaration();
        FormalParameter param = ast.newFormalParameter();
        Scalar exp = ast.newScalar(fieldName);
        param.setParameterName((Expression)exp);
        func.formalParameters().add(param);
        func.setFunctionName(rewrite.getParent().getAST().newIdentifier(CodeGenerationUtils.getSetterName(field)));
        method.setFunction(func);
        boolean isStatic = Flags.isStatic((int)flags);
        boolean isFinal = Flags.isFinal((int)flags);
        String argname = field.getElementName();
        if (argname.equals(fieldName) || !isStatic) {
            fieldName = isStatic ? String.valueOf(parentType.getElementName()) + "::" + fieldName : "$this->" + CodeGenerationUtils.removeDollarSign(fieldName);
        }
        int modifiers = 0;
        if (isStatic) {
            modifiers |= 0x80;
        }
        if (isFinal) {
            modifiers |= 4;
        }
        if (Flags.isPublic((int)flags)) {
            modifiers |= 0x40;
        }
        if (Flags.isProtected((int)flags)) {
            modifiers |= 0x20;
        }
        if (Flags.isPrivate((int)flags)) {
            modifiers |= 0x10;
        }
        method.setModifier(modifiers);
        Block body = ast.newBlock();
        func.setBody(body);
        String bodyContent = CodeGeneration.getSetterMethodBodyContent(field.getScriptProject(), parentType.getTypeQualifiedName(), setterName, fieldName, field.getElementName(), lineDelim);
        if (bodyContent != null) {
            ASTNode todoNode = rewrite.getASTRewrite().createStringPlaceholder(bodyContent, 22);
            body.statements().add((Statement)todoNode);
        }
        if (addComments) {
            String filedType = CodeGenerationUtils.getFieldType(field);
            String comment = CodeGeneration.getSetterComment(field.getScriptProject(), field.getDeclaringType().getElementName(), setterName, fieldName, filedType, field.getElementName(), field.getElementName(), lineDelim);
            if (comment != null) {
                Comment commentNode = (Comment)rewrite.getASTRewrite().createStringPlaceholder(String.valueOf(comment) + lineDelim, 16);
                commentNode.setCommentType(2);
                method.setComment(commentNode);
            }
        }
        CodeGenerationUtils.addNewAccessor((ASTNode)method, rewrite, insertion);
    }

    private static String getFieldType(IField field) throws ModelException {
        String fieldType = field.getType();
        IType type = field.getDeclaringType();
        PHPClassType classType = PHPClassType.fromIType((IType)type);
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)type.getSourceModule(), null);
        PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
        FileContext fileContext = new FileContext(type.getSourceModule(), moduleDeclaration, field.getNameRange().getOffset());
        TypeContext typeContext = new TypeContext((ISourceModuleContext)fileContext, (IEvaluatedType)classType);
        PHPDocClassVariableGoal phpDocGoal = new PHPDocClassVariableGoal(typeContext, field.getElementName(), field.getNameRange().getOffset());
        IEvaluatedType evaluatedType = typeInferencer.evaluateTypePHPDoc((AbstractTypeGoal)phpDocGoal, 3000);
        if (evaluatedType instanceof UnknownType) {
            ClassVariableDeclarationGoal goal = new ClassVariableDeclarationGoal((IContext)typeContext, new IType[]{type}, field.getElementName());
            evaluatedType = typeInferencer.evaluateType((AbstractTypeGoal)goal);
        }
        if (!(evaluatedType instanceof UnknownType)) {
            fieldType = evaluatedType.getTypeName();
        }
        if (StringUtils.isEmpty((CharSequence)fieldType)) {
            fieldType = PHPSimpleTypes.MIXED.getTypeName();
        }
        return fieldType;
    }

    private static String removeDollarSign(String fieldName) {
        String name = fieldName;
        if (CodeGenerationUtils.isDollared(name)) {
            name = name.substring(1);
        }
        return name;
    }

    private static boolean isDollared(String variableName) {
        return variableName.indexOf(36) == 0;
    }

    private static void addNewAccessor(ASTNode node, ListRewrite rewrite, ASTNode insertion) throws ModelException {
        if (insertion != null) {
            rewrite.insertBefore(node, insertion, null);
        } else {
            rewrite.insertLast(node, null);
        }
    }

    public static void createGetterStub(IField field, String getterName, boolean addComments, int flags, IType type, ListRewrite rewrite, ASTNode insertion) throws CoreException {
        String fieldName = field.getElementName();
        IType parentType = field.getDeclaringType();
        String lineDelim = StubUtility.getLineDelimiterUsed(field.getScriptProject());
        AST ast = rewrite.getASTRewrite().getAST();
        MethodDeclarationStub method = new MethodDeclarationStub(ast);
        FunctionDeclaration func = ast.newFunctionDeclaration();
        func.setFunctionName(ast.newIdentifier(CodeGenerationUtils.getGetterName(field)));
        method.setFunction(func);
        boolean isStatic = Flags.isStatic((int)flags);
        boolean isFinal = Flags.isFinal((int)flags);
        fieldName = isStatic ? String.valueOf(parentType.getElementName()) + "::" + fieldName : "$this->" + CodeGenerationUtils.removeDollarSign(fieldName);
        int modifiers = 0;
        if (isStatic) {
            modifiers |= 0x80;
        }
        if (isFinal) {
            modifiers |= 4;
        }
        if (Flags.isPublic((int)flags)) {
            modifiers |= 0x40;
        }
        if (Flags.isProtected((int)flags)) {
            modifiers |= 0x20;
        }
        if (Flags.isPrivate((int)flags)) {
            modifiers |= 0x10;
        }
        method.setModifier(modifiers);
        Block body = ast.newBlock();
        func.setBody(body);
        String bodyContent = CodeGeneration.getGetterMethodBodyContent(field.getScriptProject(), parentType.getElementName(), getterName, fieldName, lineDelim);
        if (bodyContent != null) {
            ASTNode todoNode = rewrite.getASTRewrite().createStringPlaceholder(bodyContent, 22);
            body.statements().add((Statement)todoNode);
        }
        if (addComments) {
            String filedType = CodeGenerationUtils.getFieldType(field);
            String comment = CodeGeneration.getGetterComment(field.getScriptProject(), field.getDeclaringType().getElementName(), getterName, fieldName, filedType, field.getElementName(), lineDelim);
            if (comment != null) {
                Comment commentNode = (Comment)rewrite.getASTRewrite().createStringPlaceholder(String.valueOf(comment) + lineDelim, 16);
                commentNode.setCommentType(2);
                method.setComment(commentNode);
            }
        }
        CodeGenerationUtils.addNewAccessor((ASTNode)method, rewrite, insertion);
    }

    public static IModelElement findNextSibling(IModelElement member) throws ModelException {
        IModelElement parent = member.getParent();
        if (parent instanceof IParent) {
            IModelElement[] elements = ((IParent)parent).getChildren();
            int i = elements.length - 2;
            while (i >= 0) {
                if (member.equals(elements[i])) {
                    return elements[i + 1];
                }
                --i;
            }
        }
        return null;
    }

    public static ASTNode getNodeToInsertBefore(ListRewrite listRewrite, IModelElement sibling) throws ModelException {
        if (sibling instanceof IMember) {
            ISourceRange sourceRange = ((IMember)sibling).getSourceRange();
            if (sourceRange == null) {
                return null;
            }
            int insertPos = sourceRange.getOffset();
            return CodeGenerationUtils.getNodeToInsertBefore(listRewrite, insertPos);
        }
        return null;
    }

    public static ASTNode getNodeToInsertBefore(ListRewrite listRewrite, int insertPos) {
        List members = listRewrite.getOriginalList();
        for (Object object : members) {
            ASTNode curr = (ASTNode)object;
            if (curr.getStart() < insertPos) continue;
            return curr;
        }
        return null;
    }

    public static IModelElement getCurrentModelElement(IModelElement source, PHPStructuredEditor editor, ITextSelection selection) throws ExecutionException {
        StructuredTextViewer viewer = editor.getTextViewer();
        Point originalSelection = viewer.getSelectedRange();
        int offset = -1;
        if (originalSelection == null) {
            if (selection instanceof TextSelection) {
                TextSelection textSelection = (TextSelection)selection;
                offset = textSelection.getOffset();
            }
        } else {
            offset = originalSelection.x;
        }
        if (source instanceof ISourceModule) {
            ISourceModule module = (ISourceModule)source;
            try {
                return module.getElementAt(offset);
            }
            catch (ModelException e) {
                throw new ExecutionException("Error trying to resolve document's element", (Throwable)e);
            }
        }
        return null;
    }

    public static PHPStructuredEditor getPHPEditor(ExecutionEvent event) {
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        PHPStructuredEditor textEditor = null;
        if (editorPart instanceof PHPStructuredEditor) {
            textEditor = (PHPStructuredEditor)editorPart;
        } else {
            Object o = editorPart.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (PHPStructuredEditor)o;
            }
        }
        return textEditor;
    }

    public static IMethodBinding[] getOverridableMethods(AST ast, ITypeBinding typeBinding, boolean isSubType) {
        int n;
        IMethodBinding[] iMethodBindingArray;
        IMethodBinding[] typeMethods;
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        IMethodBinding[] iMethodBindingArray2 = typeMethods = typeBinding.getDeclaredMethods();
        int n2 = typeMethods.length;
        int n3 = 0;
        while (n3 < n2) {
            IMethodBinding methodBinding = iMethodBindingArray2[n3];
            int modifiers = methodBinding.getModifiers();
            if (!Flags.isPrivate((int)modifiers)) {
                allMethods.add(methodBinding);
            }
            ++n3;
        }
        ITypeBinding clazz = typeBinding.getSuperclass();
        while (clazz != null) {
            IMethodBinding[] methods;
            iMethodBindingArray = methods = clazz.getDeclaredMethods();
            n = methods.length;
            int n4 = 0;
            while (n4 < n) {
                IMethodBinding methodBinding = iMethodBindingArray[n4];
                int modifiers = methodBinding.getModifiers();
                if (!Flags.isPrivate((int)modifiers) && CodeGenerationUtils.findOverridingMethod(methodBinding, allMethods) == null) {
                    allMethods.add(methodBinding);
                }
                ++n4;
            }
            clazz = clazz.getSuperclass();
        }
        clazz = typeBinding;
        while (clazz != null) {
            ITypeBinding[] superInterfaces = clazz.getInterfaces();
            iMethodBindingArray = superInterfaces;
            n = superInterfaces.length;
            int n5 = 0;
            while (n5 < n) {
                IMethodBinding superInterface = iMethodBindingArray[n5];
                CodeGenerationUtils.getOverridableMethods(ast, (ITypeBinding)superInterface, allMethods);
                ++n5;
            }
            clazz = clazz.getSuperclass();
        }
        if (!isSubType) {
            allMethods.removeAll(Arrays.asList(typeMethods));
        }
        if (!typeBinding.isInterface()) {
            int index = allMethods.size() - 1;
            while (index >= 0) {
                IMethodBinding method = (IMethodBinding)allMethods.get(index);
                int modifiers = method.getModifiers();
                if (PHPFlags.isFinal((int)modifiers)) {
                    allMethods.remove(index);
                }
                --index;
            }
        }
        return allMethods.toArray(new IMethodBinding[allMethods.size()]);
    }

    private static IMethodBinding findOverridingMethod(IMethodBinding method, List<IMethodBinding> allMethods) {
        for (IMethodBinding curr : allMethods) {
            if (!Bindings.isSubsignature((IMethodBinding)curr, (IMethodBinding)method)) continue;
            return curr;
        }
        return null;
    }

    private static void getOverridableMethods(AST ast, ITypeBinding superBinding, List<IMethodBinding> allMethods) {
        ITypeBinding[] superInterfaces;
        IMethodBinding[] methods;
        IMethodBinding[] iMethodBindingArray = methods = superBinding.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            int modifiers = method.getModifiers();
            if (!method.isConstructor() && !PHPFlags.isPrivate((int)modifiers) && CodeGenerationUtils.findOverridingMethod(method, allMethods) == null) {
                allMethods.add(method);
            }
            ++n2;
        }
        ITypeBinding[] iTypeBindingArray = superInterfaces = superBinding.getInterfaces();
        int n3 = superInterfaces.length;
        n = 0;
        while (n < n3) {
            ITypeBinding superInterface = iTypeBindingArray[n];
            CodeGenerationUtils.getOverridableMethods(ast, superInterface, allMethods);
            ++n;
        }
    }

    public static IMethodBinding[] getUnimplementedMethods(ITypeBinding typeBinding) {
        return CodeGenerationUtils.getUnimplementedMethods(typeBinding, false);
    }

    public static IMethodBinding[] getUnimplementedMethods(ITypeBinding typeBinding, boolean implementAbstractsOfInput) {
        int modifiers;
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        ArrayList<IMethodBinding> toImplement = new ArrayList<IMethodBinding>();
        IMethodBinding[] typeMethods = typeBinding.getDeclaredMethods();
        IMethodBinding[] iMethodBindingArray = typeMethods;
        int n = typeMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding typeMethod = iMethodBindingArray[n2];
            modifiers = typeMethod.getModifiers();
            if (!(typeMethod.isConstructor() || PHPFlags.isStatic((int)modifiers) || PHPFlags.isPrivate((int)modifiers))) {
                allMethods.add(typeMethod);
            }
            ++n2;
        }
        ITypeBinding superClass = typeBinding.getSuperclass();
        HashSet<ITypeBinding> bindingSet = new HashSet<ITypeBinding>();
        while (superClass != null && !bindingSet.contains(superClass)) {
            bindingSet.add(superClass);
            IMethodBinding[] iMethodBindingArray2 = typeMethods = superClass.getDeclaredMethods();
            modifiers = typeMethods.length;
            int n3 = 0;
            while (n3 < modifiers) {
                IMethodBinding curr = iMethodBindingArray2[n3];
                int modifiers2 = curr.getModifiers();
                if (!(curr.isConstructor() || PHPFlags.isStatic((int)modifiers2) || PHPFlags.isPrivate((int)modifiers2) || CodeGenerationUtils.findMethodBinding(curr, allMethods) != null)) {
                    allMethods.add(curr);
                }
                ++n3;
            }
            superClass = superClass.getSuperclass();
        }
        for (IMethodBinding curr : allMethods) {
            modifiers = curr.getModifiers();
            if (!PHPFlags.isAbstract((int)modifiers) && !curr.getDeclaringClass().isInterface() || !implementAbstractsOfInput && typeBinding == curr.getDeclaringClass()) continue;
            toImplement.add(curr);
        }
        HashSet<ITypeBinding> visited = new HashSet<ITypeBinding>();
        ITypeBinding curr = typeBinding;
        bindingSet.clear();
        while (curr != null && !bindingSet.contains(curr)) {
            ITypeBinding[] superInterfaces;
            bindingSet.add(curr);
            ITypeBinding[] iTypeBindingArray = superInterfaces = curr.getInterfaces();
            int n4 = superInterfaces.length;
            int n5 = 0;
            while (n5 < n4) {
                ITypeBinding superInterface = iTypeBindingArray[n5];
                CodeGenerationUtils.findUnimplementedInterfaceMethods(superInterface, visited, allMethods, toImplement);
                ++n5;
            }
            curr = curr.getSuperclass();
        }
        return toImplement.toArray(new IMethodBinding[toImplement.size()]);
    }

    private static void findUnimplementedInterfaceMethods(ITypeBinding typeBinding, Set<ITypeBinding> visited, List<IMethodBinding> allMethods, List<IMethodBinding> toImplement) {
        if (visited.add(typeBinding)) {
            ITypeBinding[] superInterfaces;
            IMethodBinding[] typeMethods;
            IMethodBinding[] iMethodBindingArray = typeMethods = typeBinding.getDeclaredMethods();
            int n = typeMethods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding curr = iMethodBindingArray[n2];
                IMethodBinding impl = CodeGenerationUtils.findMethodBinding(curr, allMethods);
                if (impl == null || !Bindings.isVisibleInHierarchy((IMethodBinding)impl)) {
                    if (impl != null) {
                        allMethods.remove(impl);
                    }
                    toImplement.add(curr);
                    allMethods.add(curr);
                }
                ++n2;
            }
            ITypeBinding[] iTypeBindingArray = superInterfaces = typeBinding.getInterfaces();
            int n3 = superInterfaces.length;
            n = 0;
            while (n < n3) {
                ITypeBinding superInterface = iTypeBindingArray[n];
                CodeGenerationUtils.findUnimplementedInterfaceMethods(superInterface, visited, allMethods, toImplement);
                ++n;
            }
        }
    }

    private static IMethodBinding findMethodBinding(IMethodBinding method, List<IMethodBinding> allMethods) {
        for (IMethodBinding curr : allMethods) {
            if (!Bindings.isSubsignature((IMethodBinding)method, (IMethodBinding)curr)) continue;
            return curr;
        }
        return null;
    }

    private static int getImplementationModifiers(IMethodBinding method, boolean deferred) {
        int modifiers = method.getModifiers() & 0xFFFFFFEF;
        modifiers &= 0xFFFFFFFE;
        if (deferred) {
            modifiers &= 0xFFFFFFDF;
            modifiers |= 0x40;
        }
        return modifiers;
    }

    public static MethodDeclaration createImplementationStub(Program unit, ASTRewrite rewrite, IMethodBinding binding, String type, CodeGenerationSettings settings, boolean deferred) throws CoreException {
        String comment;
        AST ast = rewrite.getAST();
        MethodDeclarationStub decl = new MethodDeclarationStub(ast);
        decl.setModifier(CodeGenerationUtils.getImplementationModifiers(binding, deferred));
        FunctionDeclaration func = ast.newFunctionDeclaration();
        func.setFunctionName(ast.newIdentifier(binding.getName()));
        func.setFlags(CodeGenerationUtils.getImplementationModifiers(binding, deferred));
        decl.setFunction(func);
        IMethod method = (IMethod)((MethodBinding)binding).getPHPElement();
        MethodDeclaration methodDecl = null;
        if (method.getSourceModule() != unit.getSourceModule()) {
            Program program = null;
            ISourceModule source = method.getSourceModule();
            IProject project = source.getScriptProject().getProject();
            ASTParser parserForExpected = ASTParser.newParser((PHPVersion)ProjectOptions.getPHPVersion((IProject)project), (boolean)ProjectOptions.useShortTags((IProject)project));
            try {
                parserForExpected.setSource(source);
                program = parserForExpected.createAST((IProgressMonitor)new NullProgressMonitor());
                program.recordModifications();
                program.setSourceModule(source);
                ASTNode function = program.getElementAt(method.getSourceRange().getOffset());
                if (function instanceof FunctionDeclaration) {
                    methodDecl = (MethodDeclaration)function.getParent();
                }
                if (function instanceof MethodDeclaration) {
                    methodDecl = (MethodDeclaration)function;
                }
            }
            catch (Exception e) {
                PHPUiPlugin.log(e);
            }
        } else {
            ASTNode function = unit.getElementAt(method.getSourceRange().getOffset());
            if (function instanceof FunctionDeclaration) {
                methodDecl = (MethodDeclaration)function.getParent();
            }
            if (function instanceof MethodDeclaration) {
                methodDecl = (MethodDeclaration)function;
            }
        }
        List typeParams = null;
        List typeParameters = null;
        if (methodDecl != null) {
            func.setReturnType((Identifier)ASTNode.copySubtree((AST)ast, (ASTNode)methodDecl.getFunction().getReturnType()));
            typeParams = methodDecl.getFunction().formalParameters();
            typeParameters = func.formalParameters();
            int i = 0;
            while (typeParams != null && i < typeParams.size()) {
                Expression ptype;
                FormalParameter curr = (FormalParameter)typeParams.get(i);
                FormalParameter newTypeParam = ast.newFormalParameter();
                Expression exp = (Expression)ASTNode.copySubtree((AST)ast, (ASTNode)curr.getParameterName());
                newTypeParam.setParameterName(exp);
                newTypeParam.setIsVariadic(curr.isVariadic());
                Expression value = curr.getDefaultValue();
                if (value != null) {
                    newTypeParam.setDefaultValue((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)value));
                }
                if ((ptype = curr.getParameterType()) != null) {
                    NamespaceName newName;
                    Expression expression = (Expression)ASTNode.copySubtree((AST)ast, (ASTNode)ptype);
                    if (ptype instanceof NamespaceName && !(newName = (NamespaceName)expression).isGlobal()) {
                        String fullName = PHPModelUtils.getFullName((NamespaceName)newName);
                        String[] names = (fullName = PHPModelUtils.getFullName((String)fullName, (ISourceModule)method.getSourceModule(), (int)newName.getStart())).split("\\\\");
                        if (names.length > 1) {
                            newName.segments().clear();
                            newName.setGlobal(true);
                            int j = 0;
                            while (j < names.length) {
                                Identifier identifier = ast.newIdentifier();
                                identifier.setName(names[j]);
                                newName.segments().add(identifier);
                                ++j;
                            }
                        }
                    }
                    newTypeParam.setParameterType(expression);
                }
                typeParameters.add(newTypeParam);
                ++i;
            }
        }
        String delimiter = StubUtility.getLineDelimiterUsed(unit.getSourceModule().getScriptProject());
        if (!deferred) {
            Block body = ast.newBlock();
            func.setBody(body);
            String bodyStatement = "";
            String placeHolder = CodeGeneration.getMethodBodyContent(unit.getSourceModule().getScriptProject(), type, binding.getName(), false, bodyStatement, delimiter);
            if (placeHolder != null) {
                ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 22);
                body.statements().add((Statement)todoNode);
                if (CodeGenerationUtils.addReturnStatement(methodDecl)) {
                    Identifier parentIdentifier = ast.newIdentifier("parent");
                    FunctionName functionName = ast.newFunctionName((Expression)ast.newIdentifier(binding.getName()));
                    FunctionInvocation functionInvocation = ast.newFunctionInvocation(functionName, null);
                    StaticMethodInvocation expression = ast.newStaticMethodInvocation(parentIdentifier, functionInvocation);
                    body.statements().add(ast.newReturnStatement((Expression)expression));
                }
            }
        }
        if (settings != null && settings.createComments && (comment = CodeGeneration.getMethodComment(method, method, delimiter)) != null) {
            Comment phpdoc = (Comment)rewrite.createStringPlaceholder(String.valueOf(comment) + delimiter, 16);
            phpdoc.setCommentType(2);
            decl.setComment(phpdoc);
        }
        return decl;
    }

    private static boolean addReturnStatement(MethodDeclaration methodDecl) {
        if (methodDecl == null || methodDecl.getFunction() == null || methodDecl.getFunction().getBody() == null) {
            return false;
        }
        final AtomicBoolean add = new AtomicBoolean(false);
        methodDecl.getFunction().getBody().accept((Visitor)new AbstractVisitor(){

            public boolean visit(ReturnStatement expressionStatement) {
                add.set(true);
                return false;
            }
        });
        return add.get();
    }

    public static IEditorPart openInEditor(IModelElement inputElement, boolean activate) throws PartInitException {
        IEditorInput input;
        if (inputElement instanceof IField) {
            IModelElement source;
            IEditorPart editor;
            IWorkbenchPage page = PHPUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart iEditorPart = editor = page != null ? page.getActiveEditor() : null;
            if (editor != null && editor instanceof PHPStructuredEditor && (source = ((PHPStructuredEditor)editor).getModelElement()).equals(((IField)inputElement).getSourceModule())) {
                if (activate && page != null && page.getActivePart() != editor) {
                    page.activate((IWorkbenchPart)editor);
                }
                return editor;
            }
        }
        if ((input = CodeGenerationUtils.getEditorInput(inputElement)) == null) {
            Status status = new Status(4, "org.eclipse.php.ui", 0, "Can't open editor", null);
            throw new PartInitException((IStatus)status);
        }
        return CodeGenerationUtils.openInEditor(input, CodeGenerationUtils.getEditorID(input), activate);
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage page = PHPUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            Status status = new Status(4, "org.eclipse.php.ui", 0, "Can't open editor", null);
            throw new PartInitException((IStatus)status);
        }
        return page.openEditor(input, editorID, activate);
    }

    private static IEditorInput getEditorInput(IModelElement element) {
        IResource resource;
        if (element != null && (resource = element.getResource()) instanceof IFile) {
            return new FileEditorInput((IFile)resource);
        }
        return null;
    }

    public static String getEditorID(IEditorInput input) throws PartInitException {
        IEditorDescriptor editorDescriptor;
        if (input instanceof IFileEditorInput) {
            editorDescriptor = IDE.getEditorDescriptor((IFile)((IFileEditorInput)input).getFile(), (boolean)true, (boolean)false);
        } else {
            String name = input.getName();
            if (name == null) {
                Status status = new Status(4, "org.eclipse.php.ui", 0, "Can't find editor", null);
                throw new PartInitException((IStatus)status);
            }
            editorDescriptor = IDE.getEditorDescriptor((String)name, (boolean)true, (boolean)false);
        }
        return editorDescriptor.getId();
    }

    public static IModelElement getCurrentModelElement(ExecutionEvent event) throws ExecutionException {
        PHPStructuredEditor textEditor = CodeGenerationUtils.getPHPEditor(event);
        IModelElement modelElement = null;
        if (textEditor != null) {
            modelElement = textEditor.getModelElement();
        }
        if (textEditor != null && modelElement != null) {
            ISelectionProvider selectionProvider = textEditor.getSelectionProvider();
            StructuredTextViewer viewer = textEditor.getTextViewer();
            Point originalSelection = viewer.getSelectedRange();
            int offset = -1;
            if (originalSelection == null) {
                ISelection selection = selectionProvider.getSelection();
                if (selection instanceof TextSelection) {
                    TextSelection textSelection = (TextSelection)selection;
                    offset = textSelection.getOffset();
                }
            } else {
                offset = originalSelection.x;
            }
            if (modelElement instanceof ISourceModule) {
                ISourceModule module = (ISourceModule)modelElement;
                try {
                    return module.getElementAt(offset);
                }
                catch (ModelException e) {
                    throw new ExecutionException("Error trying to resolve document's element", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static IType getType(IModelElement element) {
        if (element == null) {
            return null;
        }
        IModelElement model = element;
        while (!(model instanceof IType)) {
            if (model == null) {
                return null;
            }
            IModelElement parent = model.getParent();
            if (parent == model) {
                return null;
            }
            model = parent;
            if (!(model instanceof ISourceModule)) continue;
            return null;
        }
        return (IType)model;
    }

    public static Program getASTRoot(ISourceModule source, IDocument document, IProject project) {
        ASTParser parserForExpected = ASTParser.newParser((PHPVersion)ProjectOptions.getPHPVersion((IProject)project), (ISourceModule)source);
        Program program = null;
        try {
            parserForExpected.setSource(document.get().toCharArray());
            program = parserForExpected.createAST((IProgressMonitor)new NullProgressMonitor());
            program.setSourceModule(source);
            StringReader reader = new StringReader(document.get());
            program.initCommentMapper(document, (AstLexer)new PHPAstLexer((Reader)reader));
            program.recordModifications();
        }
        catch (Exception e) {
            PHPUiPlugin.log(e);
        }
        return program;
    }

    private static class MethodDeclarationStub
    extends MethodDeclaration
    implements MethodStub {
        public MethodDeclarationStub(AST ast) {
            super(ast);
        }
    }
}

