/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.launching.XDebugLaunch;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.phpIni.PHPINIUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandlersManager;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class XDebugExeLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new XDebugLaunch(configuration, mode, null);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        PHPexeItem[] items;
        Path filePath;
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        PHPexeItem phpExeItem = PHPLaunchUtilities.getPHPExe(configuration);
        if (phpExeItem == null) {
            Logger.log(4, "Launch configuration could not find PHP exe item");
            monitor.setCanceled(true);
            monitor.done();
            return;
        }
        String phpExeString = configuration.getAttribute("ATTR_LOCATION", null);
        String phpIniString = configuration.getAttribute("ATTR_INI_LOCATION", null);
        String phpScriptString = configuration.getAttribute("ATTR_FILE", null);
        if (phpScriptString == null || phpScriptString.trim().length() == 0) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            this.displayErrorMessage(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_0);
            return;
        }
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource scriptRes = workspaceRoot.findMember((IPath)(filePath = new Path(phpScriptString)));
        if (scriptRes == null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            this.displayErrorMessage(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_1);
            return;
        }
        Path phpExe = new Path(phpExeString);
        IProject project = scriptRes.getProject();
        String projectString = project.getFullPath().toString();
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        wc.setAttribute("org.eclipse.php.debug.core.PHP_Project", projectString);
        wc.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(project));
        wc.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(project));
        wc.doSave();
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        IPath phpFile = scriptRes.getLocation();
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        File phpIni = phpIniString != null && new File(phpIniString).exists() ? new File(phpIniString) : PHPINIUtil.findPHPIni(phpExeString);
        File tempIni = PHPINIUtil.prepareBeforeLaunch(phpIni, phpExeString, project);
        launch.setAttribute("PHPIniLocation", tempIni.getAbsolutePath());
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        String programName = phpExe.lastSegment();
        String extension = phpExe.getFileExtension();
        if (extension != null) {
            programName = programName.substring(0, programName.length() - (extension.length() + 1));
        }
        programName = programName.toLowerCase();
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
        processAttributes.put(IProcess.ATTR_CMDLINE, phpScriptString);
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        String[] envVarString = null;
        DBGpTarget target = null;
        if (mode.equals("debug")) {
            boolean stopAtFirstLine = PHPProjectPreferences.getStopAtFirstLine(project);
            stopAtFirstLine = configuration.getAttribute("firstLineBreakpoint", stopAtFirstLine);
            String sessionID = DBGpSessionHandler.getInstance().generateSessionId();
            String ideKey = null;
            if (phpExeItem != null) {
                DBGpProxyHandler proxyHandler = DBGpProxyHandlersManager.INSTANCE.getHandler(phpExeItem.getUniqueId());
                if (proxyHandler != null && proxyHandler.useProxy()) {
                    ideKey = proxyHandler.getCurrentIdeKey();
                    if (!proxyHandler.registerWithProxy()) {
                        this.displayErrorMessage(String.valueOf(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_2) + proxyHandler.getErrorMsg());
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                        return;
                    }
                } else {
                    ideKey = DBGpSessionHandler.getInstance().getIDEKey();
                }
            }
            target = new DBGpTarget(launch, phpFile.lastSegment(), ideKey, sessionID, stopAtFirstLine);
            target.setPathMapper(PathMapperRegistry.getByLaunchConfiguration(configuration));
            DBGpSessionHandler.getInstance().addSessionListener(target);
            envVarString = this.createDebugLaunchEnvironment(configuration, sessionID, ideKey, (IPath)phpExe);
            int requestPort = this.getDebugPort(phpExeItem);
            if (!PHPLaunchUtilities.isDebugDaemonActive(requestPort, "org.eclipse.php.debug.core.xdebugDebugger")) {
                PHPLaunchUtilities.showLaunchErrorMessage(NLS.bind((String)PHPDebugCoreMessages.ExeLaunchConfigurationDelegate_PortInUse, (Object)requestPort, (Object)phpExeItem.getName()));
                monitor.setCanceled(true);
                monitor.done();
                return;
            }
        } else {
            envVarString = PHPLaunchUtilities.getEnvironment(configuration, new String[]{this.getLibraryPath((IPath)phpExe)});
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 30);
        subMonitor.beginTask(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_3, 10);
        IPath workingPath = phpFile.removeLastSegments(1);
        File workingDir = workingPath.makeAbsolute().toFile();
        boolean found = false;
        int i = 0;
        while (i < envVarString.length && !found) {
            String envEntity = envVarString[i];
            String[] elements = envEntity.split("=");
            if (elements.length > 0 && elements[0].equals("XDEBUG_WORKING_DIR")) {
                found = true;
                workingPath = new Path(elements[1]);
                File temp = workingPath.makeAbsolute().toFile();
                if (temp.exists()) {
                    workingDir = temp;
                }
            }
            ++i;
        }
        File phpExeFile = new File(phpExeString);
        String sapiType = null;
        String phpV = null;
        PHPexeItem[] pHPexeItemArray = items = PHPexes.getInstance().getAllItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem item = pHPexeItemArray[n2];
            if (item.getExecutable().equals(phpExeFile)) {
                sapiType = item.getSapiType();
                phpV = item.getVersion();
                break;
            }
            ++n2;
        }
        String[] args = null;
        if ("CLI".equals(sapiType)) {
            args = PHPLaunchUtilities.getProgramArguments(launch.getLaunchConfiguration());
        }
        String[] cmdLine = null;
        cmdLine = PHPLaunchUtilities.getCommandLine(configuration, phpExe.toOSString(), tempIni.toString(), phpFile.toOSString(), args, phpV);
        Process phpExeProcess = DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envVarString);
        new Thread(new ProcessCrashDetector(launch, phpExeProcess)).start();
        IProcess eclipseProcessWrapper = null;
        if (phpExeProcess != null) {
            subMonitor.worked(10);
            String processName = mode.equals("debug") ? String.valueOf(phpExe.toOSString()) + ' ' + PHPDebugCoreMessages.PHPProcess_XDebug_suffix : phpExe.toOSString();
            eclipseProcessWrapper = DebugPlugin.newProcess((ILaunch)launch, (Process)phpExeProcess, (String)processName, processAttributes);
            if (eclipseProcessWrapper == null) {
                phpExeProcess.destroy();
                subMonitor.done();
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.core", 0, null, null));
            }
            if (mode.equals("debug") && target != null) {
                target.setProcess(eclipseProcessWrapper);
                launch.addDebugTarget((IDebugTarget)target);
                subMonitor.subTask(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_4);
                target.waitForInitialSession((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), XDebugPreferenceMgr.createSessionPreferences(), monitor);
            }
        } else {
            if (mode.equals("debug")) {
                DBGpSessionHandler.getInstance().removeSessionListener(target);
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
        subMonitor.done();
    }

    public String[] createDebugLaunchEnvironment(ILaunchConfiguration configuration, String sessionID, String ideKey, IPath phpExe) throws CoreException {
        String configEnv = "XDEBUG_CONFIG=remote_enable=1 idekey=" + ideKey;
        String extraDBGpEnv = "DBGP_IDEKEY=" + ideKey;
        String sessEnv = "DBGP_COOKIE=" + sessionID;
        Logger.debugMSG("env=" + configEnv + ", Cookie=" + sessEnv);
        String[] envVarString = PHPLaunchUtilities.getEnvironment(configuration, new String[]{configEnv, extraDBGpEnv, sessEnv, this.getLibraryPath(phpExe)});
        return envVarString;
    }

    private String getLibraryPath(IPath exePath) {
        return PHPLaunchUtilities.getLibrarySearchPathEnv(new File(exePath.removeLastSegments(1).toOSString()));
    }

    protected int getDebugPort(PHPexeItem phpExe) throws CoreException {
        int customRequestPort = XDebugDebuggerSettingsUtil.getDebugPort(phpExe.getUniqueId());
        if (customRequestPort != -1) {
            return customRequestPort;
        }
        return PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.xdebugDebugger");
    }

    protected void displayErrorMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.XDebugMessage_debugError, (String)message);
            }
        });
    }
}

