/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IBorderItemWithLocator;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.ExternalLabelPrimaryDragRoleEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.GetChildLayoutEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedBorderNamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.MaskManagedNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AffixedNamedElementFigure;
import org.eclipse.papyrus.uml.diagram.common.locator.ExternalLabelPositionLocator;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;

public class AroundBorderItemEditPart
extends RoundedBorderNamedElementEditPart
implements IBorderItemWithLocator {
    private LayoutListener.Stub layoutInitializationListener;
    private IFigure contentPane = null;
    private AffixedNamedElementFigure primaryShape;

    public AroundBorderItemEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("ConnectionLabelsPolicy", (EditPolicy)new ShowHideLabelEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new BorderItemResizableEditPolicy());
        this.installEditPolicy("MaskManagedLabelPolicy", (EditPolicy)new MaskManagedNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new GetChildLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof IBorderItemEditPart) {
                    return new ExternalLabelPrimaryDragRoleEditPolicy(){

                        protected List createSelectionHandles() {
                            MoveHandle mh = new MoveHandle((GraphicalEditPart)this.getHost());
                            mh.setBorder(null);
                            return Collections.singletonList(mh);
                        }
                    };
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        ExternalLabelPositionLocator locator = new ExternalLabelPositionLocator(this.getMainFigure());
        borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getSize_Width().equals(feature) || NotationPackage.eINSTANCE.getSize_Height().equals(feature) || NotationPackage.eINSTANCE.getLocation_X().equals(feature) || NotationPackage.eINSTANCE.getLocation_Y().equals(feature)) {
            this.refreshVisuals();
        }
        super.handleNotificationEvent(event);
    }

    public void activate() {
        this.layoutInitializationListener = new LayoutListener.Stub(){

            public void postLayout(IFigure container) {
                AroundBorderItemEditPart.this.refreshVisuals();
                AroundBorderItemEditPart.this.layoutInitializationListener = null;
            }
        };
        this.getBorderedFigure().getBorderItemContainer().addLayoutListener((LayoutListener)this.layoutInitializationListener);
        super.activate();
    }

    protected NodeFigure createNodePlate() {
        RoundedRectangleNodePlateFigure result = new RoundedRectangleNodePlateFigure(20, 20);
        return result;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    @Override
    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new AffixedNamedElementFigure();
        return this.primaryShape;
    }

    @Override
    public AffixedNamedElementFigure getPrimaryShape() {
        return this.primaryShape;
    }

    public IBorderItemLocator getNewBorderItemLocator(IFigure mainFigure) {
        return new PortPositionLocator(mainFigure, 0);
    }
}

