/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class StringMask
extends AbstractListEditor
implements SelectionListener,
IChangeListener,
DisposeListener {
    private Button[] checkboxes;
    private Collection<String> currentValue;
    private final Composite checkboxContainer;
    private boolean refreshCheckboxes = true;
    private boolean isReadOnly = false;
    public static final String DATA_KEY = "stringValue";

    public StringMask(Composite parent, int style) {
        super(parent, style);
        this.checkboxContainer = new Composite((Composite)this, style);
        this.checkboxContainer.setLayoutData((Object)this.getDefaultLayoutData());
        this.checkboxContainer.setLayout((Layout)new GridLayout(2, true));
        this.checkboxContainer.addDisposeListener((DisposeListener)this);
    }

    @Override
    protected GridData getLabelLayoutData() {
        GridData data = super.getLabelLayoutData();
        data.verticalAlignment = 1;
        return data;
    }

    public Collection<String> getValue() {
        HashSet<String> values = new HashSet<String>();
        Button[] buttonArray = this.checkboxes;
        int n = this.checkboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            if (button.getSelection()) {
                String value = (String)button.getData(DATA_KEY);
                values.add(value);
            }
            ++n2;
        }
        return values;
    }

    public void dispose() {
        if (this.modelProperty != null) {
            this.modelProperty.removeChangeListener((IChangeListener)this);
        }
        super.dispose();
    }

    @Override
    public Object getEditableType() {
        return String.class;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
        Button[] buttonArray = this.checkboxes;
        int n = this.checkboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.setEnabled(!readOnly);
            ++n2;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setMasks(Map<String, String> values) {
        if (this.checkboxes != null) {
            this.disposeCheckboxes();
        }
        this.checkboxes = new Button[values.size()];
        int i = 0;
        for (Map.Entry<String, String> mask : values.entrySet()) {
            String stringValue = mask.getKey();
            String label = mask.getValue();
            this.checkboxes[i] = new Button(this.checkboxContainer, 32);
            this.checkboxes[i].setText(label);
            this.checkboxes[i].setData(DATA_KEY, (Object)stringValue);
            this.checkboxes[i].addSelectionListener((SelectionListener)this);
            this.checkboxes[i].setToolTipText(stringValue);
            ++i;
        }
    }

    protected void disposeCheckboxes() {
        Button[] buttonArray = this.checkboxes;
        int n = this.checkboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.removeSelectionListener((SelectionListener)this);
            button.dispose();
            ++n2;
        }
    }

    public void setNumColumns(int numColumns) {
        ((GridLayout)this.checkboxContainer.getLayout()).numColumns = numColumns;
        this.checkboxContainer.layout();
        this.layout();
    }

    @Override
    public void doBinding() {
        this.modelProperty.addChangeListener((IChangeListener)this);
        this.refreshCheckboxes();
    }

    protected void refreshCheckboxes() {
        if (!this.refreshCheckboxes) {
            return;
        }
        Collection<String> values = this.getCurrentValue();
        Button[] buttonArray = this.checkboxes;
        int n = this.checkboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            String value = (String)button.getData(DATA_KEY);
            button.setSelection(values.contains(value));
            ++n2;
        }
    }

    public void setToolTipText(String text) {
        super.setLabelToolTipText(text);
    }

    public void widgetSelected(SelectionEvent e) {
        Button button = (Button)e.widget;
        String value = (String)button.getData(DATA_KEY);
        HashSet<String> values = new HashSet<String>(this.getCurrentValue());
        if (button.getSelection()) {
            values.add(value);
        } else {
            values.remove(value);
        }
        this.setCurrentValue(values);
    }

    protected void setCurrentValue(Collection<String> values) {
        if (this.modelProperty != null) {
            this.refreshCheckboxes = false;
            this.modelProperty.clear();
            this.modelProperty.addAll(values);
            this.refreshCheckboxes = true;
        }
        this.currentValue = values;
        this.commit();
    }

    protected Collection<String> getCurrentValue() {
        if (this.modelProperty != null) {
            return this.modelProperty;
        }
        return this.currentValue;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public int getNumColumns() {
        return ((GridLayout)this.checkboxContainer.getLayout()).numColumns;
    }

    public void handleChange(ChangeEvent event) {
        this.refreshCheckboxes();
    }

    @Override
    public void changeColorField() {
    }
}

