/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SelectionMenu {
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    private Shell parentShell;
    private Point location;
    private Object input;
    private Shell shell;
    private TableViewer tableViewer;
    private ISelectionChangedListener selectionChangedListener;
    private List<ISelectionChangedListener> selectionChangedListeners;
    private KeyListener keyListener;
    private List<KeyListener> keyListeners;
    private MouseTrackListener mouseTrackListener;
    private List<MouseTrackListener> mouseTrackListeners;

    public SelectionMenu(Shell parentShell) {
        this(parentShell, parentShell.getDisplay().getCursorLocation());
    }

    public SelectionMenu(Shell parentShell, Object source) {
        if (parentShell != null) {
            if (source instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)source;
                int selectionIndex = tableViewer.getTable().getSelectionIndex();
                int cellHeight = tableViewer.getTable().getItem((int)selectionIndex).getBounds().height;
                int y = tableViewer.getTable().getShell().getLocation().y;
                int width = tableViewer.getTable().getShell().getBounds().width;
                int x = tableViewer.getTable().getShell().getLocation().x + width;
                Point location = new Point(x, y += selectionIndex * cellHeight);
                this.init(parentShell, location, -1, 0);
                return;
            }
            this.init(parentShell, parentShell.getDisplay().getCursorLocation(), 1, 1);
        }
    }

    public SelectionMenu(Shell parentShell, Object source, Point cursorPosition) {
        if (parentShell != null) {
            Table table;
            TableItem item;
            if (source instanceof Table && cursorPosition != null && (item = (table = (Table)source).getItem(cursorPosition)) != null) {
                int selectionIndex = 0;
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    if (tableItem.equals(item)) break;
                    ++selectionIndex;
                    ++n2;
                }
                int cellHeight = item.getBounds().height;
                int y = table.getShell().getLocation().y;
                int width = table.getShell().getBounds().width;
                int x = table.getShell().getLocation().x + width;
                Point location = new Point(x, y += selectionIndex * cellHeight);
                this.init(parentShell, location, -1, 0);
                return;
            }
            this.init(parentShell, parentShell.getDisplay().getCursorLocation(), 1, 1);
        }
    }

    public SelectionMenu(Shell parentShell, Point location) {
        this.init(parentShell, location, 1, 1);
    }

    protected void init(Shell parentShell, Point location, int xOffset, int yOffset) {
        location.x += xOffset;
        location.y += yOffset;
        this.parentShell = parentShell;
        this.location = location;
        this.labelProvider = new LabelProvider();
        this.selectionChangedListeners = new LinkedList<ISelectionChangedListener>();
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                for (ISelectionChangedListener listener : SelectionMenu.this.selectionChangedListeners) {
                    listener.selectionChanged(event);
                }
            }
        };
        this.keyListeners = new LinkedList<KeyListener>();
        this.keyListener = new KeyListener(){

            public void keyPressed(KeyEvent event) {
                for (KeyListener listener : SelectionMenu.this.keyListeners) {
                    listener.keyPressed(event);
                }
            }

            public void keyReleased(KeyEvent event) {
                for (KeyListener listener : SelectionMenu.this.keyListeners) {
                    listener.keyReleased(event);
                }
            }
        };
        this.mouseTrackListeners = new LinkedList<MouseTrackListener>();
        this.mouseTrackListener = new MouseTrackListener(){

            public void mouseEnter(MouseEvent event) {
                for (MouseTrackListener mouseTrackListener : SelectionMenu.this.mouseTrackListeners) {
                    mouseTrackListener.mouseEnter(event);
                }
            }

            public void mouseExit(MouseEvent event) {
                for (MouseTrackListener mouseTrackListener : SelectionMenu.this.mouseTrackListeners) {
                    mouseTrackListener.mouseExit(event);
                }
            }

            public void mouseHover(MouseEvent event) {
                for (MouseTrackListener mouseTrackListener : SelectionMenu.this.mouseTrackListeners) {
                    mouseTrackListener.mouseHover(event);
                }
            }
        };
    }

    public void open() {
        this.shell = new Shell(this.parentShell, 0);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setBackgroundMode(1);
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer((Composite)this.shell, 16);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.tableViewer.setInput(this.input);
        this.tableViewer.addSelectionChangedListener(this.selectionChangedListener);
        this.tableViewer.getTable().addKeyListener(this.keyListener);
        this.tableViewer.getTable().addMouseTrackListener(this.mouseTrackListener);
        this.shell.setLocation(this.location);
        this.shell.pack();
        this.shell.open();
    }

    public void refresh() {
        this.tableViewer.refresh();
        this.shell.pack();
    }

    public void dispose() {
        if (this.tableViewer != null) {
            this.tableViewer.removeSelectionChangedListener(this.selectionChangedListener);
            if (this.tableViewer.getTable() != null) {
                this.tableViewer.getTable().removeKeyListener(this.keyListener);
            }
        }
        if (this.shell != null) {
            this.shell.dispose();
        }
    }

    public void setContentProvider(IStructuredContentProvider provider) {
        this.contentProvider = provider;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.keyListeners.add(listener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.mouseTrackListeners.add(listener);
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public Shell getParentShell() {
        return this.parentShell;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }
}

