/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.export.image;

public enum ImageFormat {
    BMP,
    JPG,
    JPEG,
    PNG;

    private static final String BMP_EXT = "BMP";
    private static final String JPG_EXT = "JPG";
    private static final String JPEG_EXT = "JPEG";
    private static final String PNG_EXT = "PNG";
    private static final String BMP_FILTER_NAME = "BMP files (*.bmp)";
    private static final String JPG_FILTER_NAME = "JPG files (*.jpg)";
    private static final String JPEG_FILTER_NAME = "JPEG files (*.jpeg)";
    private static final String PNG_FILTER_NAME = "PNG files (*.png)";
    private static final String BMP_FILTER_EXT = "*.bmp";
    private static final String JPG_FILTER_EXT = "*.jpg";
    private static final String JPEG_FILTER_EXT = "*.jpeg";
    private static final String PNG_FILTER_EXT = "*.png";
    public static final String DEFAULT_IMAGE_NAME = "table_export.png";
    public static final String[] IMAGE_EXTENSION_LIST;
    public static final String[] IMAGE_FILTER_NAME_LIST;
    public static final String[] IMAGE_FILTER_EXTENSION_LIST;

    static {
        IMAGE_EXTENSION_LIST = new String[]{PNG_EXT, BMP_EXT, JPG_EXT, JPEG_EXT};
        IMAGE_FILTER_NAME_LIST = new String[]{PNG_FILTER_NAME, BMP_FILTER_NAME, JPG_FILTER_NAME, JPEG_FILTER_NAME};
        IMAGE_FILTER_EXTENSION_LIST = new String[]{PNG_FILTER_EXT, BMP_FILTER_EXT, JPG_FILTER_EXT, JPEG_FILTER_EXT};
    }

    public static String getImageFilterExtension(ImageFormat imageFormat) {
        switch (imageFormat) {
            case BMP: {
                return BMP_FILTER_EXT;
            }
            case JPG: {
                return JPG_FILTER_EXT;
            }
            case JPEG: {
                return JPEG_FILTER_EXT;
            }
            case PNG: {
                return PNG_FILTER_EXT;
            }
        }
        return null;
    }

    public static String getDefaultImageExtension() {
        return PNG_EXT;
    }
}

