/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.projects.impl;

import java.net.URI;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.projects.PathVariableTask;
import org.eclipse.oomph.setup.projects.ProjectsPackage;
import org.eclipse.oomph.util.ObjectUtil;

public class PathVariableTaskImpl
extends SetupTaskImpl
implements PathVariableTask {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String URI_EDEFAULT = null;
    protected String uRI = URI_EDEFAULT;

    protected PathVariableTaskImpl() {
    }

    protected EClass eStaticClass() {
        return ProjectsPackage.Literals.PATH_VARIABLE_TASK;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldName, (Object)this.name));
        }
    }

    public String getURI() {
        return this.uRI;
    }

    public void setURI(String newURI) {
        String oldURI = this.uRI;
        this.uRI = newURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldURI, (Object)this.uRI));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getName();
            }
            case 11: {
                return this.getURI();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setName((String)newValue);
                return;
            }
            case 11: {
                this.setURI((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 11: {
                this.setURI(URI_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 11: {
                return URI_EDEFAULT == null ? this.uRI != null : !URI_EDEFAULT.equals(this.uRI);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", uRI: ");
        result.append(this.uRI);
        result.append(')');
        return result.toString();
    }

    public Object getOverrideToken() {
        return this.createToken(this.getName());
    }

    public int getProgressMonitorWork() {
        return 0;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        URI value = pathVariableManager.getURIValue(this.getName());
        return !ObjectUtil.equals((Object)(value == null ? null : value.toString()), (Object)this.getURI());
    }

    public void perform(SetupTaskContext context) throws Exception {
        String name = this.getName();
        String uri = this.getURI();
        context.log("Setting path variable " + name + " = " + uri);
        IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        pathVariableManager.setURIValue(name, uri == null ? null : new URI(uri));
    }
}

