/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.CallExp;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.PartialEvaluator;
import org.eclipse.ocl.examples.impactanalyzer.PartialEvaluatorFactory;
import org.eclipse.ocl.examples.impactanalyzer.ValueNotFoundException;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.PathCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.SemanticIdentity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateCheckNavigationStep
extends AbstractNavigationStep {
    private final String contentAsString;
    private final SemanticIdentity semanticIdentity;
    private final PartialEvaluatorFactory partialEvaluatorFactory;
    private final boolean positive;
    private final IteratorExp iteratorExp;
    private final OppositeEndFinder oppositeEndFinder;
    private final OCLFactory oclFactory;

    public PredicateCheckNavigationStep(EClass sourceType, EClass targetType, IteratorExp iteratorExp, PathCache pathCache, OCLFactory oclFactory) {
        super(sourceType, targetType, (OCLExpression)iteratorExp);
        this.iteratorExp = iteratorExp;
        this.oclFactory = oclFactory;
        if (!PredicateCheckNavigationStep.haveIntersectingSubclassTree(sourceType, targetType)) {
            this.setAlwaysEmpty();
        }
        this.positive = iteratorExp.getName().equals("select") || iteratorExp.getName().equals("any");
        this.oppositeEndFinder = pathCache.getOppositeEndFinder();
        this.contentAsString = "checkPredicate[" + iteratorExp.getBody().toString() + "]";
        this.semanticIdentity = new PredicateCheckNavigationStepIdentity();
        this.partialEvaluatorFactory = pathCache.getInstanceScopeAnalysis().getPartialEvaluatorFactory();
    }

    public SemanticIdentity getSemanticIdentityOfSuper() {
        return super.getSemanticIdentity();
    }

    private IteratorExp getIteratorExp() {
        return this.iteratorExp;
    }

    @Override
    protected Set<AnnotatedEObject> navigate(AnnotatedEObject fromObject, TracebackCache cache, Notification atPre) {
        LinkedHashSet<AnnotatedEObject> result = new LinkedHashSet<AnnotatedEObject>(1);
        LinkedHashSet<EObject> sourceValue = new LinkedHashSet<EObject>(1);
        sourceValue.add(fromObject.getAnnotatedObject());
        boolean passedPredicate = this.evaluate((OCLExpression)this.getIteratorExp(), sourceValue, atPre);
        if (passedPredicate) {
            result.add(fromObject);
        }
        return result;
    }

    private Boolean evaluate(OCLExpression exp, Collection<EObject> sourceObjects, Notification atPre) {
        Boolean resultPre = this.positive;
        if (atPre != null) {
            PartialEvaluator evalPre = this.partialEvaluatorFactory.createPartialEvaluator(atPre, this.oppositeEndFinder, this.oclFactory);
            try {
                Object result = evalPre.evaluate(null, (CallExp)exp, sourceObjects);
                resultPre = sourceObjects.contains(result);
            }
            catch (ValueNotFoundException vnfe) {
                resultPre = this.positive;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("The result of the iterator expression's body is not of type Boolean.");
            }
        }
        PartialEvaluator evalPost = this.partialEvaluatorFactory.createPartialEvaluator(this.oppositeEndFinder, this.oclFactory);
        Boolean resultPost = this.positive;
        if (atPre == null || resultPre != this.positive) {
            try {
                Object result = evalPost.evaluate(null, (CallExp)exp, sourceObjects);
                resultPost = result instanceof Collection ? (((Collection)result).isEmpty() ? Boolean.valueOf(false) : Boolean.valueOf(sourceObjects.contains(((Collection)result).iterator().next()))) : Boolean.valueOf(sourceObjects.contains(result));
            }
            catch (ValueNotFoundException vnfe) {
                resultPost = this.positive;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("The result of the iterator expression's body is not of type Boolean.");
            }
        }
        if ((atPre == null || resultPre != this.positive) && resultPost != this.positive) {
            return false;
        }
        return true;
    }

    @Override
    public String contentToString(Map<NavigationStep, Integer> visited, int indent) {
        return this.contentAsString;
    }

    @Override
    public SemanticIdentity getSemanticIdentity() {
        return this.semanticIdentity;
    }

    private class PredicateCheckNavigationStepIdentity
    extends SemanticIdentity {
        private PredicateCheckNavigationStepIdentity() {
        }

        public PredicateCheckNavigationStep getNavigationStep() {
            return PredicateCheckNavigationStep.this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.hashCode() != o.hashCode()) {
                return false;
            }
            return PredicateCheckNavigationStep.this.getSemanticIdentityOfSuper().equals(o) && PredicateCheckNavigationStep.this.positive == ((PredicateCheckNavigationStepIdentity)o).getNavigationStep().positive && PredicateCheckNavigationStep.this.iteratorExp.equals(((PredicateCheckNavigationStepIdentity)o).getNavigationStep().iteratorExp);
        }

        public int calculateHashCode() {
            return PredicateCheckNavigationStep.this.getSemanticIdentityOfSuper().hashCode() ^ (PredicateCheckNavigationStep.this.positive ? 123 : 0) ^ PredicateCheckNavigationStep.this.iteratorExp.hashCode();
        }

        public NavigationStep getStep() {
            return this.getNavigationStep();
        }
    }
}

