/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.http.internal.server;

import java.text.MessageFormat;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.connector.IServerConnector;
import org.eclipse.net4j.http.internal.common.HTTPConnector;
import org.eclipse.net4j.http.internal.server.HTTPAcceptor;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPServerConnector
extends HTTPConnector
implements IServerConnector {
    private HTTPAcceptor acceptor;

    public HTTPServerConnector(HTTPAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public HTTPAcceptor getAcceptor() {
        return this.acceptor;
    }

    public ILocationAware.Location getLocation() {
        return ILocationAware.Location.SERVER;
    }

    public String getURL() {
        return "agent://connector:" + this.getConnectorID();
    }

    public int getMaxIdleTime() {
        return this.acceptor.getMaxIdleTime();
    }

    public String toString() {
        if (this.getUserID() == null) {
            return MessageFormat.format("HTTPServerConnector[{0}]", this.getConnectorID());
        }
        return MessageFormat.format("HTTPServerConnector[{1}@{0}]", this.getConnectorID(), this.getUserID());
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.leaveConnecting();
    }

    protected void registerChannelWithPeer(short channelID, long timeout, IProtocol<?> protocol) throws ChannelException {
        throw new UnsupportedOperationException();
    }

    protected boolean pollAgain() {
        try {
            Thread.sleep(100L);
            return true;
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }
}

