/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbstractRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class GerritOperationFactory {
    private final IRepositoryManager repositoryManager;

    public GerritOperationFactory(IRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public <T> GerritOperation<T> createOperation(ITask review, AbstractRequest<T> request) {
        return new GerritOperation<T>(request.getOperationName(), this.getClient(review), request);
    }

    public GerritClient getClient(ITask review) {
        TaskRepository repository = this.repositoryManager.getRepository(review.getConnectorKind(), review.getRepositoryUrl());
        GerritConnector connector = (GerritConnector)this.repositoryManager.getRepositoryConnector(repository.getConnectorKind());
        GerritClient client = connector.getClient(repository);
        return client;
    }
}

