/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.server.StreamConnectionProvider;

public abstract class ProcessStreamConnectionProvider
implements StreamConnectionProvider {
    private @Nullable Process process;
    private List<String> commands;
    private String workingDir;

    public ProcessStreamConnectionProvider() {
    }

    public ProcessStreamConnectionProvider(List<String> commands, String workingDir) {
        this.commands = commands;
        this.workingDir = workingDir;
    }

    @Override
    public void start() throws IOException {
        Process p;
        if (this.workingDir == null || this.commands == null || this.commands.isEmpty() || this.commands.stream().anyMatch(Objects::isNull)) {
            throw new IOException("Unable to start language server: " + this.toString());
        }
        ProcessBuilder builder = this.createProcessBuilder();
        this.process = p = builder.start();
        if (!p.isAlive()) {
            throw new IOException("Unable to start language server: " + this.toString());
        }
    }

    protected ProcessBuilder createProcessBuilder() {
        ProcessBuilder builder = new ProcessBuilder(this.getCommands());
        builder.directory(new File(this.getWorkingDirectory()));
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        return builder;
    }

    @Override
    public @Nullable InputStream getInputStream() {
        Process p = this.process;
        return p == null ? null : p.getInputStream();
    }

    @Override
    public @Nullable OutputStream getOutputStream() {
        Process p = this.process;
        return p == null ? null : p.getOutputStream();
    }

    @Override
    public void stop() {
        Process p = this.process;
        if (p != null) {
            p.destroy();
        }
    }

    protected List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    protected String getWorkingDirectory() {
        return this.workingDir;
    }

    public void setWorkingDirectory(String workingDir) {
        this.workingDir = workingDir;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessStreamConnectionProvider)) {
            return false;
        }
        ProcessStreamConnectionProvider other = (ProcessStreamConnectionProvider)obj;
        if (this.getCommands().size() != other.getCommands().size()) {
            return false;
        }
        return this.getCommands().containsAll(other.getCommands()) && this.getWorkingDirectory().equals(other.getWorkingDirectory());
    }

    public int hashCode() {
        int result = Objects.hashCode(this.getCommands());
        return result ^ Objects.hashCode(this.getWorkingDirectory());
    }
}

