/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.references;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;

public class LSSearchResult
extends FileSearchResult {
    private ISearchQuery query;
    private CompletableFuture<List<? extends Location>> references;

    public LSSearchResult(CompletableFuture<List<? extends Location>> references) {
        super(null);
        this.references = references;
    }

    protected Match toMatch(Location location, IProgressMonitor monitor) {
        try {
            IResource resource = LSPEclipseUtils.findResourceFor(location.getUri());
            IDocument document = LSPEclipseUtils.getDocument(resource);
            if (document != null) {
                int startOffset = LSPEclipseUtils.toOffset(location.getRange().getStart(), document);
                int endOffset = LSPEclipseUtils.toOffset(location.getRange().getEnd(), document);
                IRegion lineInformation = document.getLineInformationOfOffset(startOffset);
                LineElement lineEntry = new LineElement(resource, document.getLineOfOffset(startOffset), lineInformation.getOffset(), document.get(lineInformation.getOffset(), lineInformation.getLength()));
                return new FileMatch((IFile)resource, startOffset, endOffset - startOffset, lineEntry);
            }
            Position startPosition = location.getRange().getStart();
            LineElement lineEntry = new LineElement(resource, startPosition.getLine(), 0, String.format("%s:%s", startPosition.getLine(), startPosition.getCharacter()));
            return new FileMatch((IFile)resource, 0, 0, lineEntry);
        }
        catch (BadLocationException ex) {
            LanguageServerPlugin.logError(ex);
            return null;
        }
    }

    public String getLabel() {
        return "References TODO Label";
    }

    public String getTooltip() {
        return "References TODO Tooltip";
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        if (this.query == null) {
            this.query = new LSSearchQuery();
        }
        return this.query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return null;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return null;
    }

    private class LSSearchQuery
    extends FileSearchQuery {
        public LSSearchQuery() {
            super(Messages.referenceSearchQuery, false, false, null);
        }

        public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
            AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
            textResult.removeAll();
            try {
                for (Location loc : (List)LSSearchResult.this.references.get(4L, TimeUnit.SECONDS)) {
                    Match match = LSSearchResult.this.toMatch(loc, monitor);
                    LSSearchResult.this.addMatch(match);
                }
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                return new Status(4, LanguageServerPlugin.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex);
            }
        }

        public ISearchResult getSearchResult() {
            return LSSearchResult.this;
        }
    }
}

