/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import com.google.gson.Gson;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPEclipseUtils {
    private LSPEclipseUtils() {
    }

    public static ITextEditor getActiveTextEditor() {
        MultiPageEditorPart multiPageEditorPart;
        Object page;
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof ITextEditor) {
            return (ITextEditor)editorPart;
        }
        if (editorPart instanceof MultiPageEditorPart && (page = (multiPageEditorPart = (MultiPageEditorPart)editorPart).getSelectedPage()) instanceof ITextEditor) {
            return (ITextEditor)page;
        }
        return null;
    }

    public static Position toPosition(int offset, IDocument document) throws BadLocationException {
        Position res = new Position();
        res.setLine(document.getLineOfOffset(offset));
        res.setCharacter(offset - document.getLineInformationOfOffset(offset).getOffset());
        return res;
    }

    public static int toOffset(Position position, IDocument document) throws BadLocationException {
        return document.getLineInformation(position.getLine()).getOffset() + position.getCharacter();
    }

    public static TextDocumentPositionParams toTextDocumentPosistionParams(URI fileUri, int offset, IDocument document) throws BadLocationException {
        Position start = LSPEclipseUtils.toPosition(offset, document);
        TextDocumentPositionParams param = new TextDocumentPositionParams();
        param.setPosition(start);
        param.setUri(fileUri.toString());
        TextDocumentIdentifier id = new TextDocumentIdentifier();
        id.setUri(fileUri.toString());
        param.setTextDocument(id);
        return param;
    }

    public static int toEclipseMarkerSeverity(DiagnosticSeverity lspSeverity) {
        if (lspSeverity == null) {
            return 2;
        }
        switch (lspSeverity) {
            case Error: {
                return 2;
            }
            case Warning: {
                return 1;
            }
        }
        return 0;
    }

    public static @Nullable IResource findResourceFor(@Nullable String uri) {
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        String convertedUri = uri.replace("file:///", "file:/");
        convertedUri = convertedUri.replace("file://", "file:/");
        IPath path = Path.fromOSString((String)new File(URI.create(convertedUri)).getAbsolutePath());
        IProject project = null;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject aProject = iProjectArray[n2];
            IPath location = aProject.getLocation();
            if (location != null && location.isPrefixOf(path) && (project == null || project.getLocation().segmentCount() < location.segmentCount())) {
                project = aProject;
            }
            ++n2;
        }
        if (project == null) {
            return null;
        }
        IPath projectRelativePath = path.removeFirstSegments(project.getLocation().segmentCount());
        if (projectRelativePath.isEmpty()) {
            return project;
        }
        return project.findMember(projectRelativePath);
    }

    public static void applyEdit(org.eclipse.lsp4j.TextEdit textEdit, IDocument document) throws BadLocationException {
        document.replace(LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document), LSPEclipseUtils.toOffset(textEdit.getRange().getEnd(), document) - LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document), textEdit.getNewText());
    }

    public static void applyEdits(IDocument document, List<? extends org.eclipse.lsp4j.TextEdit> edits) {
        if (document == null || edits.isEmpty()) {
            return;
        }
        IDocumentUndoManager manager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
        if (manager != null) {
            manager.beginCompoundChange();
        }
        MultiTextEdit edit = new MultiTextEdit();
        for (org.eclipse.lsp4j.TextEdit textEdit : edits) {
            if (textEdit == null) continue;
            try {
                int offset = LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document);
                int length = LSPEclipseUtils.toOffset(textEdit.getRange().getEnd(), document) - offset;
                edit.addChild((TextEdit)new ReplaceEdit(offset, length, textEdit.getNewText()));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        try {
            RewriteSessionEditProcessor rewriteSessionEditProcessor = new RewriteSessionEditProcessor(document, (TextEdit)edit, 0);
            rewriteSessionEditProcessor.performEdits();
        }
        catch (BadLocationException | MalformedTreeException throwable) {
            LanguageServerPlugin.logError(throwable);
        }
        if (manager != null) {
            manager.endCompoundChange();
        }
    }

    public static @Nullable IDocument getDocument(@Nullable IResource resource) {
        if (resource == null) {
            return null;
        }
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IDocument document = null;
        ITextFileBuffer buffer = bufferManager.getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
        if (buffer != null) {
            document = buffer.getDocument();
        } else if (resource.getType() == 1) {
            try {
                bufferManager.connect(resource.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
                return document;
            }
            buffer = bufferManager.getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
            if (buffer != null) {
                document = buffer.getDocument();
            }
        }
        return document;
    }

    public static void openInEditor(Location location, IWorkbenchPage page) {
        IEditorPart part = null;
        IDocument targetDocument = null;
        IResource targetResource = LSPEclipseUtils.findResourceFor(location.getUri());
        try {
            if (targetResource != null && targetResource.getType() == 1) {
                part = IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)targetResource));
                targetDocument = FileBuffers.getTextFileBufferManager().getTextFileBuffer(targetResource.getFullPath(), LocationKind.IFILE).getDocument();
            } else {
                URI fileUri = URI.create(location.getUri()).normalize();
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileUri);
                IFileInfo fetchInfo = fileStore.fetchInfo();
                if (!fetchInfo.isDirectory() && fetchInfo.exists()) {
                    part = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    ITextFileBuffer fileStoreTextFileBuffer = FileBuffers.getTextFileBufferManager().getFileStoreTextFileBuffer(fileStore);
                    targetDocument = fileStoreTextFileBuffer.getDocument();
                }
            }
        }
        catch (PartInitException e) {
            LanguageServerPlugin.logError(e);
        }
        try {
            if (part instanceof AbstractTextEditor) {
                AbstractTextEditor editor = (AbstractTextEditor)part;
                int offset = LSPEclipseUtils.toOffset(location.getRange().getStart(), targetDocument);
                int endOffset = LSPEclipseUtils.toOffset(location.getRange().getEnd(), targetDocument);
                editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset, endOffset > offset ? endOffset - offset : 0));
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    public static IDocument getDocument(ITextEditor editor) {
        try {
            Method getSourceViewerMethod = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            getSourceViewerMethod.setAccessible(true);
            ITextViewer viewer = (ITextViewer)getSourceViewerMethod.invoke((Object)editor, new Object[0]);
            return viewer.getDocument();
        }
        catch (Exception ex) {
            LanguageServerPlugin.logError(ex);
            return null;
        }
    }

    public static IDocument getDocument(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return LSPEclipseUtils.getDocument((IResource)fileEditorInput.getFile());
        }
        if (editorInput instanceof IPathEditorInput) {
            IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput;
            return LSPEclipseUtils.getDocument((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile(pathEditorInput.getPath()));
        }
        if (editorInput instanceof IURIEditorInput) {
            IURIEditorInput uriEditorInput = (IURIEditorInput)editorInput;
            return LSPEclipseUtils.getDocument(LSPEclipseUtils.findResourceFor(uriEditorInput.getURI().toString()));
        }
        return null;
    }

    public static void applyWorkspaceEdit(WorkspaceEdit wsEdit) {
        CompositeChange change = new CompositeChange("LSP Workspace Edit");
        for (Map.Entry edit : wsEdit.getChanges().entrySet()) {
            String uri = (String)edit.getKey();
            IDocument document = LSPEclipseUtils.getDocument(LSPEclipseUtils.findResourceFor(uri));
            for (org.eclipse.lsp4j.TextEdit textEdit : (List)edit.getValue()) {
                try {
                    int offset = LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document);
                    int length = LSPEclipseUtils.toOffset(textEdit.getRange().getEnd(), document) - offset;
                    DocumentChange documentChange = new DocumentChange("Change in document " + uri, document);
                    documentChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    documentChange.setEdit((TextEdit)new ReplaceEdit(offset, length, textEdit.getNewText()));
                    change.add((Change)documentChange);
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        PerformChangeOperation changeOperation = new PerformChangeOperation((Change)change);
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)changeOperation, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    public static URI toUri(IPath absolutePath) {
        return LSPEclipseUtils.toUri(absolutePath.toFile());
    }

    public static URI toUri(IResource resource) {
        return LSPEclipseUtils.toUri(resource.getLocation());
    }

    public static URI toUri(File file) {
        try {
            return new URI("file", "", file.getAbsoluteFile().toURI().getPath(), null);
        }
        catch (URISyntaxException e) {
            LanguageServerPlugin.logError(e);
            return file.getAbsoluteFile().toURI();
        }
    }

    public static WorkspaceEdit createWorkspaceEdit(List<Object> commandArguments, IResource initialResource) {
        WorkspaceEdit res = new WorkspaceEdit();
        HashMap<String, List> changes = new HashMap<String, List>();
        res.setChanges(changes);
        Pair currentEntry = new Pair(initialResource, new ArrayList());
        commandArguments.stream().flatMap(item -> {
            if (item instanceof List) {
                return ((List)item).stream();
            }
            return Collections.singleton(item).stream();
        }).forEach(arg -> {
            Gson gson;
            org.eclipse.lsp4j.TextEdit edit;
            if (arg instanceof String) {
                changes.put(((IResource)pair.key).getLocationURI().toString(), (List)pair.value);
                IResource resource = LSPEclipseUtils.findResourceFor((String)arg);
                if (resource != null) {
                    pair.key = resource;
                    pair.value = new ArrayList();
                }
            } else if (arg instanceof WorkspaceEdit) {
                changes.putAll(((WorkspaceEdit)arg).getChanges());
            } else if (arg instanceof org.eclipse.lsp4j.TextEdit) {
                ((List)pair.value).add((org.eclipse.lsp4j.TextEdit)arg);
            } else if (arg instanceof Map && (edit = (org.eclipse.lsp4j.TextEdit)(gson = new Gson()).fromJson(gson.toJson(arg), org.eclipse.lsp4j.TextEdit.class)) != null) {
                ((List)pair.value).add(edit);
            }
        });
        changes.put(((IResource)currentEntry.key).getLocationURI().toString(), (List)currentEntry.value);
        return res;
    }

    public static @Nullable IFile getFile(IDocument document) {
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(document);
        if (buffer == null) {
            return null;
        }
        IPath location = buffer.getLocation();
        return ResourcesPlugin.getWorkspace().getRoot().getFile(location);
    }

    private static final class Pair<K, V> {
        K key;
        V value;

        Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

