/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.base.config;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.toolkit.base.config.AbstractOSAUTConfiguration;

public abstract class AbstractOSProcessAUTConfiguration
extends AbstractOSAUTConfiguration {
    @NonNull
    private String m_command;
    @Nullable
    private String[] m_args;

    public AbstractOSProcessAUTConfiguration(@Nullable String name, @NonNull String autID, @NonNull String command, @NonNull String workingDir, @Nullable String[] args) {
        super(name, autID, workingDir);
        Validate.notEmpty((String)command, (String)"The given command must not be empty");
        this.m_command = command;
        this.m_args = args;
        this.add("EXECUTABLE", this.getCommand());
        this.add("WORKING_DIR", this.getWorkingDir());
        this.add("AUT_ARGUMENTS", StringUtils.defaultString((String)StringUtils.join((Object[])this.getArgs(), (String)" ")));
    }

    @NonNull
    public String getCommand() {
        return this.m_command;
    }

    @Nullable
    public String[] getArgs() {
        return this.m_args;
    }
}

