/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import java.util.Iterator;
import java.util.concurrent.Callable;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComboComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuItemComponent;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.MenuTester;
import org.eclipse.jubula.rc.javafx.tester.adapter.JavaFXComponentAdapter;
import org.eclipse.jubula.rc.javafx.tester.util.WindowsUtil;

public class ChoiceBoxAdapter
extends JavaFXComponentAdapter<ChoiceBox<?>>
implements IComboComponent {
    public ChoiceBoxAdapter(ChoiceBox<?> objectToAdapt) {
        super(objectToAdapt);
    }

    public String getText() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                ObservableList children = ((ChoiceBox)ChoiceBoxAdapter.this.getRealComponent()).getChildrenUnmodifiable();
                Label text = null;
                for (Node node : children) {
                    if (!(node instanceof Label)) continue;
                    text = (Label)node;
                }
                if (text != null) {
                    return text.getText();
                }
                return null;
            }
        });
    }

    public boolean isEditable() {
        return false;
    }

    public void selectAll() {
        StepExecutionException.throwUnsupportedAction();
    }

    public int getSelectedIndex() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedIndex", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((ChoiceBox)ChoiceBoxAdapter.this.getRealComponent()).getSelectionModel().getSelectedIndex();
            }
        });
    }

    public void select(int index) {
        MenuTester tester = this.openMenu();
        tester.selectMenuItemByIndexpath(Integer.toString(IndexConverter.toUserIndex((int)index)));
    }

    public void input(String text, boolean replace) {
        StepExecutionException.throwUnsupportedAction();
    }

    public String[] getValues() {
        MenuTester tester = this.openMenu();
        IMenuItemComponent[] items = tester.getMenuAdapter().getItems();
        String[] result = new String[items.length];
        int i = 0;
        while (i < items.length) {
            result[i] = items[i].getText();
            ++i;
        }
        this.closeMenu((ContextMenu)tester.getComponent().getRealComponent());
        return result;
    }

    private MenuTester openMenu() {
        this.getRobot().click(this.getRealComponent(), null);
        return EventThreadQueuerJavaFXImpl.invokeAndWait("select", new Callable<MenuTester>(){

            @Override
            public MenuTester call() throws Exception {
                long now;
                MenuTester menuTester = null;
                Iterator<Window> iter = WindowsUtil.getWindowIterator();
                long timeout = 10000L;
                long done = System.currentTimeMillis() + timeout;
                do {
                    Window w;
                    if (!iter.hasNext()) {
                        iter = WindowsUtil.getWindowIterator();
                    }
                    if (!((w = iter.next()) instanceof ContextMenu) || !((ContextMenu)w).getOwnerNode().equals(ChoiceBoxAdapter.this.getRealComponent())) continue;
                    menuTester = new MenuTester();
                    menuTester.setComponent(w);
                    break;
                } while ((timeout = done - (now = System.currentTimeMillis())) > 0L);
                return menuTester;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeMenu(final ContextMenu m) {
        boolean successful;
        block8: {
            EventHandler<Event> shownHandler;
            block7: {
                final EventLock eventLock = new EventLock();
                shownHandler = new EventHandler<Event>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handle(Event event) {
                        EventLock eventLock2 = eventLock;
                        synchronized (eventLock2) {
                            eventLock.notifyAll();
                        }
                    }
                };
                EventThreadQueuerJavaFXImpl.invokeAndWait("addCloseHandler", new Callable<Void>((EventHandler)shownHandler){
                    private final /* synthetic */ EventHandler val$shownHandler;
                    {
                        this.val$shownHandler = eventHandler;
                    }

                    @Override
                    public Void call() throws Exception {
                        m.addEventHandler(WindowEvent.WINDOW_HIDDEN, this.val$shownHandler);
                        return null;
                    }
                });
                successful = false;
                this.getRobot().keyType(null, 27);
                try {
                    try {
                        if (!m.isShowing()) break block7;
                        EventLock eventLock2 = eventLock;
                        synchronized (eventLock2) {
                            eventLock.wait(10000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        successful = EventThreadQueuerJavaFXImpl.invokeAndWait("closeMenu", new Callable<Boolean>(m, (EventHandler)shownHandler){
                            private final /* synthetic */ ContextMenu val$m;
                            private final /* synthetic */ EventHandler val$shownHandler;
                            {
                                this.val$m = contextMenu;
                                this.val$shownHandler = eventHandler;
                            }

                            @Override
                            public Boolean call() throws Exception {
                                this.val$m.removeEventHandler(WindowEvent.WINDOW_HIDDEN, this.val$shownHandler);
                                return !this.val$m.isShowing();
                            }
                        });
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    successful = EventThreadQueuerJavaFXImpl.invokeAndWait("closeMenu", new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            successful = EventThreadQueuerJavaFXImpl.invokeAndWait("closeMenu", new /* invalid duplicate definition of identical inner class */);
        }
        return successful;
    }
}

