/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.beans.binding;

import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import org.eclipse.gef.common.beans.binding.MultisetBinding;
import org.eclipse.gef.common.beans.value.ObservableMultisetValue;
import org.eclipse.gef.common.collections.CollectionUtils;
import org.eclipse.gef.common.collections.ObservableMultiset;

public abstract class MultisetExpression<E>
implements ObservableMultisetValue<E> {
    private final ObservableMultiset<E> EMPTY_MULTISET = CollectionUtils.emptyMultiset();

    public static <E> MultisetExpression<E> multisetExpression(ObservableMultisetValue<E> multisetValue) {
        if (multisetValue == null) {
            throw new IllegalArgumentException("multisetValue may not be null.");
        }
        if (multisetValue instanceof MultisetExpression) {
            return (MultisetExpression)multisetValue;
        }
        return new MultisetBindingImpl<E>(multisetValue);
    }

    public boolean add(E element) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.add(element) : multiset.add(element);
    }

    public int add(E element, int occurrences) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.add(element, occurrences) : multiset.add(element, occurrences);
    }

    public boolean addAll(Collection<? extends E> c) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.addAll(c) : multiset.addAll(c);
    }

    public StringBinding asString() {
        return (StringBinding)Bindings.convert((ObservableValue)this);
    }

    public void clear() {
        Multiset multiset = (Multiset)this.get();
        if (multiset == null) {
            this.EMPTY_MULTISET.clear();
        } else {
            multiset.clear();
        }
    }

    public boolean contains(Object element) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.contains(element) : multiset.contains(element);
    }

    public boolean containsAll(Collection<?> elements) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.containsAll(elements) : multiset.containsAll(elements);
    }

    public int count(Object element) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.count(element) : multiset.count(element);
    }

    public Set<E> elementSet() {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.elementSet() : multiset.elementSet();
    }

    public abstract ReadOnlyBooleanProperty emptyProperty();

    public Set<Multiset.Entry<E>> entrySet() {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.entrySet() : multiset.entrySet();
    }

    public ObservableMultiset<E> getValue() {
        return (ObservableMultiset)this.get();
    }

    public boolean isEmpty() {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.isEmpty() : multiset.isEmpty();
    }

    public BooleanBinding isEqualTo(ObservableMultiset<?> other) {
        return Bindings.equal((ObservableObjectValue)this, other);
    }

    public BooleanBinding isNotEqualTo(ObservableMultiset<?> other) {
        return Bindings.notEqual((ObservableObjectValue)this, other);
    }

    public BooleanBinding isNotNull() {
        return Bindings.isNotNull((ObservableObjectValue)this);
    }

    public BooleanBinding isNull() {
        return Bindings.isNull((ObservableObjectValue)this);
    }

    public Iterator<E> iterator() {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.iterator() : multiset.iterator();
    }

    public boolean remove(Object element) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.remove(element) : multiset.remove(element);
    }

    public int remove(Object element, int occurrences) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.remove(element, occurrences) : multiset.remove(element, occurrences);
    }

    public boolean removeAll(Collection<?> c) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.removeAll(c) : multiset.removeAll(c);
    }

    @Override
    public boolean replaceAll(Multiset<? extends E> multiset) {
        ObservableMultiset delegate = (ObservableMultiset)this.get();
        return delegate == null ? this.EMPTY_MULTISET.replaceAll(multiset) : delegate.replaceAll(multiset);
    }

    public boolean retainAll(Collection<?> c) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.retainAll(c) : multiset.retainAll(c);
    }

    public int setCount(E element, int count) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.setCount(element, count) : multiset.setCount(element, count);
    }

    public boolean setCount(E element, int oldCount, int newCount) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.setCount(element, oldCount, newCount) : multiset.setCount(element, oldCount, newCount);
    }

    public int size() {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.size() : multiset.size();
    }

    public abstract ReadOnlyIntegerProperty sizeProperty();

    public Object[] toArray() {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.toArray() : multiset.toArray();
    }

    public <T> T[] toArray(T[] a) {
        Multiset multiset = (Multiset)this.get();
        return multiset == null ? this.EMPTY_MULTISET.toArray(a) : multiset.toArray((Object[])a);
    }

    private static final class MultisetBindingImpl<E>
    extends MultisetBinding<E> {
        private ObservableMultisetValue<E> multisetValue = null;

        public MultisetBindingImpl(ObservableMultisetValue<E> multisetValue) {
            this.multisetValue = multisetValue;
            this.bind(multisetValue);
        }

        @Override
        protected ObservableMultiset<E> computeValue() {
            return (ObservableMultiset)this.multisetValue.get();
        }
    }
}

