/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.utils;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue;

import com.google.common.collect.ImmutableList;

public class UploadReportsHandler {

    @Execute
    public void execute(ILogEventsQueue queue, UploadReportsScheduler up) {
        EList<ILogEventGroup> groups = queue.getGroups();
        ImmutableList<ILogEventGroup> copy = ImmutableList.copyOf(groups);
        groups.clear();
        up.schedule(copy);
    }

    @Execute
    public void execute(ILogEvent event, UploadReportsScheduler up) {
        up.schedule(event);
    }

    @Execute
    public void execute(ILogEventGroup group, UploadReportsScheduler up) {
        up.schedule(group);
    }
}
