/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.workspace;

import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.cdo.workspace.CDOWorkspace;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceProperties
extends Properties<CDOWorkspace> {
    public static final IProperties<CDOWorkspace> INSTANCE = new WorkspaceProperties();

    private WorkspaceProperties() {
        super(CDOWorkspace.class);
        this.add((Property)new Property<CDOWorkspace>("open", "Open", "Whether this workspace is open or not."){

            protected Object eval(CDOWorkspace workspace) {
                return !workspace.isClosed();
            }
        });
        this.add((Property)new Property<CDOWorkspace>("branchPath", "Branch", "The remote branch of this workspace."){

            protected Object eval(CDOWorkspace workspace) {
                return workspace.getBranchPath();
            }
        });
        this.add((Property)new Property<CDOWorkspace>("timeStamp", "Time Stamp", "The time stamp of this workspace."){

            protected Object eval(CDOWorkspace workspace) {
                return CDOCommonUtil.formatTimeStamp((long)workspace.getTimeStamp());
            }
        });
        this.add((Property)new Property<CDOWorkspace>("fixed", "Fixed", "Whether this workspace is fixed to a specific remote time stamp or not."){

            protected Object eval(CDOWorkspace workspace) {
                return workspace.isFixed();
            }
        });
        this.add((Property)new Property<CDOWorkspace>("dirty", "Dirty", "Whether this workspace is locally dirty or not."){

            protected Object eval(CDOWorkspace workspace) {
                return workspace.isDirty();
            }
        });
        this.add((Property)new Property<CDOWorkspace>("idGenerationLocation", "ID Generation Location", "One of STORE, CLIENT."){

            protected Object eval(CDOWorkspace workspace) {
                return ((InternalCDOWorkspace)workspace).getIDGenerationLocation();
            }
        });
        this.add((Property)new Property<CDOWorkspace>("base", "Base", "The base of this workspace."){

            protected Object eval(CDOWorkspace workspace) {
                return ((InternalCDOWorkspace)workspace).getBase();
            }
        });
        this.add((Property)new Property<CDOWorkspace>("local", "Local", "The local repository of this workspace."){

            protected Object eval(CDOWorkspace workspace) {
                return ((InternalCDOWorkspace)workspace).getLocalRepository();
            }
        });
        this.add((Property)new Property<CDOWorkspace>("remote", "Remote", "The remote repository of this workspace."){

            protected Object eval(CDOWorkspace workspace) {
                return ((InternalCDOWorkspace)workspace).getRemoteSessionConfigurationFactory();
            }
        });
    }

    public static void main(String[] args) {
        new Tester().dumpContributionMarkup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Tester
    extends DefaultPropertyTester<CDOWorkspace> {
        public static final String NAMESPACE = "org.eclipse.emf.cdo.workspace";

        public Tester() {
            super(NAMESPACE, INSTANCE);
        }
    }
}

