/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeViewer
implements ISelectionProvider {
    private final Table table;
    private final CheckboxTableViewer viewer;
    private final List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private boolean includebinaries;

    private static String getPathLabel(IPackageFragmentRoot root) {
        IPath path = root.getPath();
        try {
            if (root.getKind() == 2) {
                return path.lastSegment();
            }
        }
        catch (JavaModelException e) {
            EclEmmaUIPlugin.log(e);
        }
        return path.removeFirstSegments(1).toString();
    }

    public ScopeViewer(Composite parent, int style) {
        this(new Table(parent, 0x20 | style));
    }

    public ScopeViewer(Table table) {
        this.table = table;
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PackageFragmentRootLabelProvider());
        this.viewer.setSorter((ViewerSorter)new PackageFragmentRootSorter());
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (ScopeViewer.this.includebinaries) {
                    return true;
                }
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                try {
                    return root.getKind() == 1;
                }
                catch (JavaModelException e) {
                    EclEmmaUIPlugin.log(e);
                    return false;
                }
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ScopeViewer.this.fireSelectionEvent();
            }
        });
    }

    public Table getTable() {
        return this.table;
    }

    public void setInput(Collection<IPackageFragmentRoot> input) {
        this.viewer.setInput(input);
    }

    public void setIncludeBinaries(boolean includebinaries) {
        this.includebinaries = includebinaries;
        this.viewer.refresh();
    }

    public void setSelectedScope(Collection<IPackageFragmentRoot> scope) {
        this.viewer.setCheckedElements(scope.toArray());
    }

    public void selectAll() {
        this.viewer.setAllChecked(true);
        this.fireSelectionEvent();
    }

    public void deselectAll() {
        this.viewer.setAllChecked(false);
        this.fireSelectionEvent();
    }

    public Set<IPackageFragmentRoot> getSelectedScope() {
        HashSet<IPackageFragmentRoot> scope = new HashSet<IPackageFragmentRoot>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            scope.add((IPackageFragmentRoot)element);
            ++n2;
        }
        return scope;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void fireSelectionEvent() {
        SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener l : this.listeners) {
            l.selectionChanged(evt);
        }
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.getSelectedScope().toArray());
    }

    public void setSelection(ISelection selection) {
        ArrayList<IPackageFragmentRoot> scope = new ArrayList<IPackageFragmentRoot>();
        Object[] objectArray = ((IStructuredSelection)selection).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            scope.add((IPackageFragmentRoot)obj);
            ++n2;
        }
        this.setSelectedScope(scope);
    }

    private static class PackageFragmentRootLabelProvider
    extends LabelProvider {
        private ILabelProvider delegate = new WorkbenchLabelProvider();

        private PackageFragmentRootLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.delegate.getImage(element);
        }

        public String getText(Object element) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            String projectname = root.getJavaProject().getElementName();
            String path = ScopeViewer.getPathLabel(root);
            if (path.length() > 0) {
                String fmt = UIMessages.ClassesViewerEntry_label;
                return NLS.bind((String)fmt, (Object)projectname, (Object)ScopeViewer.getPathLabel(root));
            }
            return projectname;
        }

        public void dispose() {
            this.delegate.dispose();
        }
    }

    private static class PackageFragmentRootSorter
    extends ViewerSorter {
        private PackageFragmentRootSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IPackageFragmentRoot root1 = (IPackageFragmentRoot)e1;
            IPackageFragmentRoot root2 = (IPackageFragmentRoot)e2;
            Comparator comparator = this.getComparator();
            int result = comparator.compare(root1.getJavaProject().getElementName(), root2.getJavaProject().getElementName());
            if (result != 0) {
                return result;
            }
            if (root1.isExternal() != root2.isExternal()) {
                return root1.isExternal() ? 1 : -1;
            }
            return comparator.compare(ScopeViewer.getPathLabel(root1), ScopeViewer.getPathLabel(root2));
        }
    }
}

